/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl;

import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import fish.payara.microprofile.openapi.impl.processor.ApplicationProcessor;
import fish.payara.microprofile.openapi.impl.processor.BaseProcessor;
import fish.payara.microprofile.openapi.impl.processor.ConfigPropertyProcessor;
import fish.payara.microprofile.openapi.impl.processor.FileProcessor;
import fish.payara.microprofile.openapi.impl.processor.FilterProcessor;
import fish.payara.microprofile.openapi.impl.processor.ModelReaderProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;

public class OpenAPISupplier
implements Supplier<OpenAPI> {
    private static final Logger logger = Logger.getLogger(OpenAPISupplier.class.getName());
    private final OpenApiConfiguration config;
    private final String applicationId;
    private final String contextRoot;
    private final ReadableArchive archive;
    private final ClassLoader classLoader;
    private volatile OpenAPI document;
    private boolean enabled;

    public OpenAPISupplier(String applicationId, String contextRoot, ReadableArchive archive, ClassLoader classLoader) {
        this.config = new OpenApiConfiguration(classLoader);
        this.applicationId = applicationId;
        this.contextRoot = contextRoot;
        this.archive = archive;
        this.classLoader = classLoader;
        this.enabled = true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OpenAPI get() {
        if (this.document != null) {
            return this.document;
        }
        if (!this.enabled) {
            return null;
        }
        try {
            Map<String, Type> types = this.collectTypesFromArchive(this.archive, this.applicationId);
            if (this.config != null && this.config.getScanLib()) {
                Map<String, Type> earLibTypes = this.collectEarLibTypes(this.archive.getParentArchive());
                types.putAll(earLibTypes);
            }
            OpenAPIImpl doc = new OpenAPIImpl();
            try {
                List<URL> baseURLs = this.getServerURL(this.contextRoot);
                doc = new ConfigPropertyProcessor().process(doc, this.config);
                doc = new ModelReaderProcessor().process(doc, this.config);
                doc = new FileProcessor(this.classLoader).process(doc, this.config);
                doc = new ApplicationProcessor(types, this.filterTypes(this.archive, types, this.config != null && this.config.getScanLib()), this.filterTypes(this.archive, types, false), this.classLoader).process(doc, this.config);
                if (doc.getPaths() != null && !doc.getPaths().getPathItems().isEmpty()) {
                    doc.setEndpoints(ModelUtils.buildEndpoints(null, this.contextRoot, doc.getPaths().getPathItems().keySet()));
                }
                doc = new BaseProcessor(baseURLs).process(doc, this.config);
                doc = new FilterProcessor().process(doc, this.config);
            }
            finally {
                this.document = doc;
            }
            return this.document;
        }
        catch (Exception ex) {
            throw new RuntimeException("An error occurred while creating the OpenAPI document.", ex);
        }
    }

    private Map<String, Type> collectEarLibTypes(ReadableArchive parentArchive) {
        HashMap<String, Type> earLibTypes = new HashMap<String, Type>();
        if (parentArchive != null) {
            Enumeration entries = parentArchive.entries();
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (!entry.startsWith("lib/") || !entry.endsWith(".jar")) continue;
                try {
                    Map<String, Type> libTypes = this.collectTypesFromArchive(parentArchive.getSubArchive(entry), this.applicationId + "-parent-" + entry);
                    earLibTypes.putAll(libTypes);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Unable to parse EAR archive '" + entry + "': " + ex.getMessage(), ex);
                }
            }
        }
        return earLibTypes;
    }

    private Map<String, Type> collectTypesFromArchive(ReadableArchive archive, String entryId) throws IOException {
        HashMap<String, Type> types = new HashMap<String, Type>();
        Parser earLibParser = ((ApplicationLifecycle)Globals.get(ApplicationLifecycle.class)).getDeployableParser(archive, true, true, StructuredDeploymentTracing.create((String)entryId), logger);
        types.putAll(OpenAPISupplier.typesToMap(earLibParser.getContext().getTypes(), archive.getURI()));
        return types;
    }

    public static Map<String, Type> typesToMap(Types types, URI archive) {
        return types.getAllTypes().stream().filter(type -> type.getDefiningURIs().stream().anyMatch(definingUri -> definingUri.getPath().contains(archive.getPath()))).collect(Collectors.toMap(t -> t.getName(), Function.identity(), (first, second) -> {
            logger.log(Level.FINE, "Duplicate type {0} detected while performing OpenAPI scanning, will use the first.", first.getName());
            logger.log(Level.FINER, "First duplicate type: {0}\n\nSecond duplicate type: {1}", new Object[]{first.toString(), second.toString()});
            return first;
        }));
    }

    private Set<Type> filterTypes(ReadableArchive archive, Map<String, Type> hk2Types, boolean scanLibs) {
        HashSet<Type> types = new HashSet<Type>();
        types.addAll(this.filterLibTypes(hk2Types, archive, scanLibs));
        types.addAll(Collections.list(archive.entries()).stream().filter(clazz -> clazz.endsWith(".class")).map(clazz -> clazz.replaceAll("WEB-INF/classes/", "").replace("/", ".").replace(".class", "")).map(clazz -> (Type)hk2Types.get(clazz)).filter(Objects::nonNull).collect(Collectors.toSet()));
        return this.config == null ? types : this.config.getValidClasses(types);
    }

    private Set<Type> filterLibTypes(Map<String, Type> hk2Types, ReadableArchive archive, boolean scanLibs) {
        HashSet<Type> types = new HashSet<Type>();
        if (scanLibs) {
            this.addFoundClasses(archive, hk2Types, "WEB-INF/lib/", types);
            this.addFoundClasses(archive.getParentArchive(), hk2Types, "lib/", types);
        }
        return types;
    }

    private void addFoundClasses(ReadableArchive archiveToScan, Map<String, Type> hk2Types, String prefix, Set<Type> types) {
        if (archiveToScan != null) {
            Enumeration subArchiveItr = archiveToScan.entries();
            while (subArchiveItr.hasMoreElements()) {
                String subArchiveName = (String)subArchiveItr.nextElement();
                if (!subArchiveName.startsWith(prefix) || !subArchiveName.endsWith(".jar")) continue;
                try {
                    ReadableArchive subArchive = archiveToScan.getSubArchive(subArchiveName);
                    types.addAll(Collections.list(subArchive.entries()).stream().filter(clazz -> clazz.endsWith(".class")).map(clazz -> clazz.replace("/", ".").replace(".class", "")).map(clazz -> (Type)hk2Types.get(clazz)).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    private List<URL> getServerURL(String contextRoot) {
        String hostName;
        ArrayList<URL> result = new ArrayList<URL>();
        ServerContext context = (ServerContext)Globals.get(ServerContext.class);
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            hostName = "localhost";
        }
        String instanceType = ((ServerEnvironment)Globals.get(ServerEnvironment.class)).getRuntimeType().toString();
        ArrayList httpPorts = new ArrayList();
        ArrayList httpsPorts = new ArrayList();
        List networkListeners = context.getConfigBean().getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener();
        String adminListener = context.getConfigBean().getConfig().getAdminListener().getName();
        networkListeners.stream().filter(networkListener -> Boolean.parseBoolean(networkListener.getEnabled())).forEach(networkListener -> {
            List ports;
            int port;
            try {
                port = ((GrizzlyService)Globals.get(GrizzlyService.class)).getRealPort(networkListener);
            }
            catch (MultiException ex) {
                port = Integer.parseInt(networkListener.getPort());
            }
            boolean securityEnabled = Boolean.parseBoolean(networkListener.findProtocol().getSecurityEnabled());
            List list = ports = securityEnabled ? httpsPorts : httpPorts;
            if (!networkListener.getName().equals(adminListener)) {
                ports.add(port);
            } else if (instanceType.equals("MICRO")) {
                ports.add(port);
            }
        });
        for (Integer httpPort : httpPorts) {
            try {
                result.add(new URL("http", hostName, httpPort, contextRoot));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        for (Integer httpsPort : httpsPorts) {
            try {
                result.add(new URL("https", hostName, httpsPort, contextRoot));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return result;
    }
}

