/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.requesttracing.jaxrs.client;

import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTelemetryService;
import fish.payara.opentracing.OpenTracingService;
import io.opentracing.Tracer;
import java.lang.annotation.Annotation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;

public final class PayaraTracingServices {
    private final RequestTracingService requestTracingService;
    private final OpenTracingService openTracingService;
    private final InvocationManager invocationManager;
    private final Deployment deployment;
    private final OpenTelemetryService openTelemetryService;

    public PayaraTracingServices() {
        ServiceLocator baseServiceLocator = Globals.getStaticBaseServiceLocator();
        this.requestTracingService = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, RequestTracingService.class);
        this.openTracingService = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, OpenTracingService.class);
        this.invocationManager = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, InvocationManager.class);
        this.deployment = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, Deployment.class);
        this.openTelemetryService = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, OpenTelemetryService.class);
    }

    public boolean isTracingAvailable() {
        return this.requestTracingService != null && this.openTracingService != null && this.openTelemetryService != null;
    }

    public RequestTracingService getRequestTracingService() {
        if (this.isTracingAvailable()) {
            return this.requestTracingService;
        }
        return null;
    }

    public OpenTracingService getOpenTracingService() {
        if (this.isTracingAvailable()) {
            return this.openTracingService;
        }
        return null;
    }

    public OpenTelemetryService getOpenTelemetryService() {
        if (this.isTracingAvailable()) {
            return this.openTelemetryService;
        }
        return null;
    }

    public InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public String getApplicationName() {
        if (this.isTracingAvailable()) {
            return this.openTracingService.getApplicationName(this.invocationManager);
        }
        return null;
    }

    public Tracer getActiveTracer() {
        String applicationName = this.getApplicationName();
        if (applicationName == null || !this.isTracingAvailable()) {
            return null;
        }
        return this.openTracingService.getTracer(applicationName);
    }

    private static final <T> T getFromServiceHandle(ServiceLocator serviceLocator, Class<T> serviceClass) {
        ServiceHandle serviceHandle = serviceLocator.getServiceHandle(serviceClass, new Annotation[0]);
        if (serviceHandle != null && serviceHandle.isActive()) {
            return (T)serviceHandle.getService();
        }
        return null;
    }
}

