/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.krazo.cdi.Internal;

@ApplicationScoped
public class BeanValidationProducer {
    private static final Logger log = Logger.getLogger(BeanValidationProducer.class.getName());
    @Inject
    private Instance<ValidatorFactory> validatorFactoryInstance;
    private ValidatorFactory validatorFactory;

    @PostConstruct
    public void init() {
        Iterator iterator = this.validatorFactoryInstance.iterator();
        if (iterator.hasNext()) {
            this.validatorFactory = (ValidatorFactory)iterator.next();
        } else {
            log.warning("Creating a ValidatorFactory because the container didn't provide one!");
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
    }

    @Produces
    @Internal
    @ApplicationScoped
    public ValidatorFactory produceValidationFactory() {
        return this.validatorFactory;
    }
}

