/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.asadmin.recorder.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.asadmin.recorder.AsadminRecorderConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable-asadmin-recorder")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="enable.asadmin.recorder")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="enable-asadmin-recorder", description="Enables the asadmin command recorder service")})
public class EnableAsadminRecorder
implements AdminCommand {
    @Inject
    AsadminRecorderConfiguration asadminRecorderConfiguration;

    public void execute(AdminCommandContext context) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AsadminRecorderConfiguration>(){

                public Object run(AsadminRecorderConfiguration asadminRecorderConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                    if (Boolean.parseBoolean(EnableAsadminRecorder.this.asadminRecorderConfiguration.isEnabled())) {
                        Logger.getLogger(EnableAsadminRecorder.class.getName()).log(Level.INFO, "Asadmin Recorder already enabled");
                    } else {
                        asadminRecorderConfigurationProxy.setEnabled(true);
                        Logger.getLogger(EnableAsadminRecorder.class.getName()).log(Level.INFO, "Asadmin Recorder enabled");
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.asadminRecorderConfiguration);
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(EnableAsadminRecorder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

