/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.bootstrap.HK2Populator;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.internal.data.ApplicationClassLoadingPostProcessor;
import org.glassfish.internal.data.ApplicationDescriptorFileFinder;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.analysis.DeploymentSpan;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;
import org.glassfish.internal.deployment.analysis.TraceContext;
import org.jvnet.hk2.config.TransactionFailure;

public class ApplicationInfo
extends ModuleInfo {
    public static final String APP_SERVICE_LOCATOR_PREFIX = "JavaEEApp.";
    private final Collection<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private final LinkedList<ModuleInfo> reversedModules = new LinkedList();
    private ReadableArchive source;
    private final Map<String, Object> transientAppMetaData = new HashMap<String, Object>();
    private String libraries;
    private boolean isJavaEEApp = false;
    private ClassLoader appClassLoader;
    private boolean isLoaded = false;
    private ServiceLocator appServiceLocator;
    private DeploymentFailedListener deploymentFailedListener;
    private static final String APPLICATION_LOADER_FILES = "META-INF/hk2-locator/application";
    private static final String WEB_LOADER_FILES = "hk2-locator/application";

    public ApplicationInfo(Events events, ReadableArchive source, String name) {
        super(events, name, new LinkedHashSet<EngineRef>(), null);
        this.source = source;
    }

    private void createServiceLocator() {
        if (this.appServiceLocator == null) {
            String locatorName = APP_SERVICE_LOCATOR_PREFIX + this.name;
            ServiceLocatorFactory slf = ServiceLocatorFactory.getInstance();
            if (slf.find(locatorName) != null) {
                slf.destroy(locatorName);
            }
            this.appServiceLocator = slf.create(locatorName);
        }
    }

    private void disposeServiceLocator() {
        if (this.appServiceLocator != null) {
            ServiceLocatorFactory.getInstance().destroy(this.appServiceLocator);
            this.appServiceLocator = null;
        }
    }

    private void registerListeners() {
        this.deploymentFailedListener = new DeploymentFailedListener(this.source);
        this.events.register((EventListener)this.deploymentFailedListener);
    }

    private void unregisterListeners() {
        if (this.deploymentFailedListener != null) {
            this.events.unregister((EventListener)this.deploymentFailedListener);
            this.deploymentFailedListener = null;
        }
    }

    public void add(EngineRef ref) {
        this.engines.add(ref);
        this.reversedEngines.addFirst(ref);
    }

    public void removeTransientAppMetaData(String metaDataKey) {
        this.transientAppMetaData.remove(metaDataKey);
    }

    public void addTransientAppMetaData(String metaDataKey, Object metaDataValue) {
        if (metaDataValue != null) {
            this.transientAppMetaData.put(metaDataKey, metaDataValue);
        }
    }

    public <T> T getTransientAppMetaData(String key, Class<T> metadataType) {
        Object metaDataValue = this.transientAppMetaData.get(key);
        if (metaDataValue != null) {
            return metadataType.cast(metaDataValue);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public void setLibraries(String libraries) {
        this.libraries = libraries;
    }

    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    public void setAppClassLoader(ClassLoader cLoader) {
        this.appClassLoader = cLoader;
    }

    public ServiceLocator getAppServiceLocator() {
        return this.appServiceLocator;
    }

    public boolean isJavaEEApp() {
        return this.isJavaEEApp;
    }

    public void setIsJavaEEApp(List<EngineInfo> engineInfos) {
        for (EngineInfo engineInfo : engineInfos) {
            Sniffer sniffer = engineInfo.getSniffer();
            if (!sniffer.isJavaEE()) continue;
            this.isJavaEEApp = true;
            break;
        }
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public Collection<ModuleInfo> getModuleInfos() {
        return this.modules;
    }

    @Override
    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef ref : this.engines) {
            sniffers.add(ref.getContainerInfo().getSniffer());
        }
        for (ModuleInfo module : this.modules) {
            sniffers.addAll(module.getSniffers());
        }
        return sniffers;
    }

    public <T extends Container> Collection<EngineRef> getEngineRefsForContainer(Class<T> type2) {
        LinkedHashSet<EngineRef> refs = new LinkedHashSet<EngineRef>();
        for (ModuleInfo info : this.modules) {
            EngineRef ref = null;
            try {
                ref = info.getEngineRefForContainer(type2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    protected ExtendedDeploymentContext getSubContext(ModuleInfo info, ExtendedDeploymentContext context) {
        return context;
    }

    @Override
    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        Logger logger = context.getLogger();
        if (this.isLoaded) {
            logger.fine("Application is already loaded.");
            return;
        }
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load(context);
        DeploymentSpan span = tracing.startSpan(TraceContext.Level.APPLICATION, this.name, DeploymentTracing.AppStage.LOAD);
        super.load(context, tracker);
        this.appClassLoader = context.getClassLoader();
        for (ModuleInfo module : this.modules) {
            module.load(this.getSubContext(module, context), tracker);
        }
        this.populateApplicationServiceLocator();
        this.isLoaded = true;
        span.close();
        if (this.events != null) {
            span = tracing.startSpan(TraceContext.Level.APPLICATION, this.name, DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.APPLICATION_LOADED.type());
            this.events.send(new EventListener.Event(Deployment.APPLICATION_LOADED, (Object)this), false);
            span.close();
        }
    }

    public void start(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        block18: {
            StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load(context);
            try (DeploymentSpan span = tracing.startSpan(DeploymentTracing.AppStage.START);){
                super.start(context, tracker);
                for (ModuleInfo module : this.getModuleInfos()) {
                    DeploymentSpan innerSpan = tracing.startSpan(TraceContext.Level.MODULE, module.getName(), DeploymentTracing.AppStage.START);
                    try {
                        module.start(this.getSubContext(module, context), tracker);
                    }
                    finally {
                        if (innerSpan == null) continue;
                        innerSpan.close();
                    }
                }
                if (this.events == null) break block18;
                try (DeploymentSpan innerSpan = tracing.startSpan(TraceContext.Level.APPLICATION, this.getName(), DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.APPLICATION_STARTED.type());){
                    this.events.send(new EventListener.Event(Deployment.APPLICATION_STARTED, (Object)this), false);
                }
            }
        }
    }

    public void reload(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load(context);
        try (DeploymentSpan span = tracing.startSpan(DeploymentTracing.AppStage.RELOAD);){
            super.reload(context, tracker);
            for (ModuleInfo module : this.getModuleInfos()) {
                DeploymentSpan innerSpan = tracing.startSpan(TraceContext.Level.MODULE, module.getName(), DeploymentTracing.AppStage.RELOAD);
                try {
                    module.reload(this.getSubContext(module, context), tracker);
                }
                finally {
                    if (innerSpan == null) continue;
                    innerSpan.close();
                }
            }
        }
    }

    public void initialize() {
        this.getModuleInfos().forEach(module -> module.getEngineRefs().forEach(EngineRef::initialize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(ExtendedDeploymentContext context, Logger logger) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appClassLoader);
            context.setClassLoader(this.appClassLoader);
            super.stop(context, logger);
            for (ModuleInfo module : this.reversedModules) {
                module.stop(this.getSubContext(module, context), logger);
            }
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.APPLICATION_STOPPED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload(ExtendedDeploymentContext context) {
        Logger logger = context.getLogger();
        if (!this.isLoaded) {
            logger.fine("Application is already unloaded.");
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appClassLoader);
            context.setClassLoader(this.appClassLoader);
            super.unload(context);
            for (ModuleInfo module : this.reversedModules) {
                module.unload(this.getSubContext(module, context));
            }
            this.isLoaded = false;
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.APPLICATION_UNLOADED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            context.setClassLoader(null);
        }
    }

    @Override
    public boolean suspend(Logger logger) {
        boolean isSuccess = super.suspend(logger);
        for (ModuleInfo module : this.reversedModules) {
            if (module.suspend(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public boolean resume(Logger logger) {
        boolean isSuccess = super.resume(logger);
        for (ModuleInfo module : this.modules) {
            if (module.resume(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    public void reset(ReadableArchive source) {
        super.reset();
        this.unregisterListeners();
        this.source = source;
        this.transientAppMetaData.clear();
        this.appClassLoader = null;
        this.isLoaded = false;
    }

    @Override
    public void clean(ExtendedDeploymentContext context) throws Exception {
        super.clean(context);
        for (ModuleInfo info : this.reversedModules) {
            info.clean(this.getSubContext(info, context));
            info = null;
        }
        if (this.appClassLoader != null) {
            try {
                if (this.appServiceLocator != null) {
                    this.appServiceLocator.preDestroy((Object)this.appClassLoader);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((PreDestroy)PreDestroy.class.cast(this.appClassLoader)).preDestroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.appClassLoader = null;
        }
        for (ModuleInfo module : this.getModuleInfos()) {
            if (module.getClassLoaders() == null) continue;
            for (ClassLoader cloader : module.getClassLoaders()) {
                try {
                    ((PreDestroy)PreDestroy.class.cast(cloader)).preDestroy();
                }
                catch (Exception exception) {}
            }
            module.cleanClassLoaders();
        }
        this.disposeServiceLocator();
        this.unregisterListeners();
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_CLEANED, (Object)context), false);
        }
    }

    public void save(Application app) throws TransactionFailure, PropertyVetoException {
        for (EngineRef ref : this.engines) {
            Engine engine = (Engine)app.createChild(Engine.class);
            app.getEngine().add(engine);
            ref.save(engine);
        }
        for (ModuleInfo module : this.modules) {
            Module modConfig = app.getModule(module.getName());
            if (modConfig == null) {
                modConfig = (Module)app.createChild(Module.class);
                modConfig.setName(module.getName());
                app.getModule().add(modConfig);
            }
            module.save(modConfig);
        }
    }

    public void addModule(ModuleInfo info) {
        this.modules.add(info);
        this.reversedModules.addFirst(info);
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    private void populateApplicationServiceLocator() throws IOException {
        this.createServiceLocator();
        this.registerListeners();
        ServiceLoader<PopulatorPostProcessor> postProcessors = ServiceLoader.load(PopulatorPostProcessor.class, this.appClassLoader);
        LinkedList<PopulatorPostProcessor> allProcessors = new LinkedList<PopulatorPostProcessor>();
        for (PopulatorPostProcessor postProcessor : postProcessors) {
            allProcessors.add(postProcessor);
        }
        allProcessors.addLast(new ApplicationClassLoadingPostProcessor(this.appClassLoader));
        HK2Populator.populate(this.appServiceLocator, new ApplicationDescriptorFileFinder(this.appClassLoader, APPLICATION_LOADER_FILES), allProcessors);
        HashSet<ClassLoader> treatedLoaders = new HashSet<ClassLoader>();
        treatedLoaders.add(this.appClassLoader);
        for (ModuleInfo module : this.modules) {
            ClassLoader moduleClassLoader = module.getModuleClassLoader();
            if (moduleClassLoader == null || treatedLoaders.contains(moduleClassLoader)) continue;
            treatedLoaders.add(moduleClassLoader);
            allProcessors.removeLast();
            allProcessors.addLast(new ApplicationClassLoadingPostProcessor(moduleClassLoader));
            HK2Populator.populate(this.appServiceLocator, new ApplicationDescriptorFileFinder(moduleClassLoader, WEB_LOADER_FILES), allProcessors);
        }
    }

    private class DeploymentFailedListener
    implements EventListener {
        private final ReadableArchive archive;

        private DeploymentFailedListener(ReadableArchive archive) {
            this.archive = archive;
        }

        public void event(@RestrictTo(value="Deployment_Failed") EventListener.Event event) {
            if (!event.is(Deployment.DEPLOYMENT_FAILURE)) {
                return;
            }
            DeploymentContext dc = (DeploymentContext)Deployment.DEPLOYMENT_FAILURE.getHook(event);
            if (!this.archive.equals(dc.getSource())) {
                return;
            }
            ApplicationInfo.this.disposeServiceLocator();
            ApplicationInfo.this.unregisterListeners();
        }
    }
}

