/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.azure.admin;

import com.sun.enterprise.util.StringUtils;
import fish.payara.microprofile.config.extensions.azure.AzureSecretsConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.BaseSetConfigSourceConfigurationCommand;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="set-azure-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-azure-config-source-configuration", description="Configures Azure Secrets Config Source")})
public class SetAzureSecretsConfigSourceConfigurationCommand
extends BaseSetConfigSourceConfigurationCommand<AzureSecretsConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(SetAzureSecretsConfigSourceConfigurationCommand.class.getPackage().getName());
    @Param(optional=true, name="tenant-id", alias="tenantId")
    protected String tenantId;
    @Param(optional=true, name="client-id", alias="clientId")
    protected String clientId;
    @Param(optional=true, name="key-vault-name", alias="keyVaultName")
    protected String keyVaultName;
    @Param(optional=true, name="private-key-file", alias="privateKeyFile")
    private File privateKeyFile;
    @Param(optional=true)
    private String thumbprint;
    @Inject
    private ServerEnvironment env;

    @Override
    protected void applyValues(ActionReport report, AzureSecretsConfigSourceConfiguration configuration) throws PropertyVetoException {
        super.applyValues(report, configuration);
        if (StringUtils.ok((String)this.tenantId)) {
            configuration.setTenantId(this.tenantId);
        }
        if (StringUtils.ok((String)this.clientId)) {
            configuration.setClientId(this.clientId);
        }
        if (StringUtils.ok((String)this.keyVaultName)) {
            configuration.setKeyVaultName(this.keyVaultName);
        }
        if (StringUtils.ok((String)this.thumbprint)) {
            configuration.setThumbprint(this.thumbprint);
        }
        if (this.privateKeyFile != null) {
            if (!this.privateKeyFile.exists() || !this.privateKeyFile.isFile()) {
                throw new PropertyVetoException("Private Key file not found", new PropertyChangeEvent(configuration, "privateKeyFile", null, this.privateKeyFile));
            }
            try {
                Path configDirPath = this.env.getConfigDirPath().toPath();
                Path output = Files.copy(this.privateKeyFile.toPath(), configDirPath.resolve(this.privateKeyFile.getName()), StandardCopyOption.REPLACE_EXISTING);
                configuration.setPrivateKeyFilePath(configDirPath.relativize(output).toString());
                LOGGER.info("File copied to " + output);
            }
            catch (IOException e) {
                String message = "Unable to find or access target file";
                LOGGER.log(Level.WARNING, "Unable to find or access target file", e);
                throw new PropertyVetoException("Unable to find or access target file", new PropertyChangeEvent(configuration, "privateKeyFile", null, this.privateKeyFile));
            }
        }
    }
}

