/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.dynamodb;

import fish.payara.microprofile.config.extensions.aws.client.AwsRequestBuilder;
import fish.payara.microprofile.config.extensions.dynamodb.DynamoDBConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.annotations.Service;

@Service(name="dynamodb-config-source")
public class DynamoDBConfigSource
extends ConfiguredExtensionConfigSource<DynamoDBConfigSourceConfiguration> {
    public static final Set<String> SUPPORTED_DATA_TYPES = new HashSet<String>(Arrays.asList("S", "N", "B", "BOOL", "NULL"));
    private static final Logger LOGGER = Logger.getLogger(DynamoDBConfigSource.class.getName());
    private AwsRequestBuilder builder;
    @Inject
    MicroprofileConfigConfiguration mpconfig;

    @Override
    public void bootstrap() {
        try {
            String accessKeyId = TranslatedConfigView.getRealPasswordFromAlias((String)"${ALIAS=AWS_ACCESS_KEY_ID}");
            String secretAccessKey = TranslatedConfigView.getRealPasswordFromAlias((String)"${ALIAS=AWS_SECRET_ACCESS_KEY}");
            this.builder = AwsRequestBuilder.builder(accessKeyId, secretAccessKey).region(((DynamoDBConfigSourceConfiguration)this.configuration).getRegionName()).serviceName("DynamoDB").method("POST").ContentType("application/json").data(Json.createObjectBuilder().add("TableName", ((DynamoDBConfigSourceConfiguration)this.configuration).getTableName()).add("ProjectionExpression", ((DynamoDBConfigSourceConfiguration)this.configuration).getKeyColumnName() + "," + ((DynamoDBConfigSourceConfiguration)this.configuration).getValueColumnName()).add("Limit", Integer.parseInt(((DynamoDBConfigSourceConfiguration)this.configuration).getLimit())).build());
        }
        catch (IllegalArgumentException ex) {
            DynamoDBConfigSource.printMisconfigurationMessage();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOGGER.log(Level.WARNING, "Unable to get value from password aliases", ex);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.builder == null) {
            DynamoDBConfigSource.printMisconfigurationMessage();
            return new HashMap<String, String>();
        }
        Response response = this.builder.action("Scan").build().invoke();
        if (response.getStatus() != 200) {
            LOGGER.log(Level.WARNING, "Failed to get data from DynamoDB. {0}", response.readEntity(String.class));
        } else {
            try {
                JsonArray items = DynamoDBConfigSource.readItems((InputStream)response.getEntity());
                return DynamoDBConfigSource.readDataFromItems(items, ((DynamoDBConfigSourceConfiguration)this.configuration).getKeyColumnName(), ((DynamoDBConfigSourceConfiguration)this.configuration).getValueColumnName());
            }
            catch (JsonException | ProcessingException ex) {
                LOGGER.log(Level.WARNING, "Failed to read the data retrived from your DynamoDB", ex);
            }
        }
        return new HashMap<String, String>();
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    @Override
    public String getValue(String propertyName) {
        if (this.builder == null) {
            DynamoDBConfigSource.printMisconfigurationMessage();
            return null;
        }
        return this.getProperties().get(propertyName);
    }

    public static Map<String, String> readDataFromItems(JsonArray items, String keyColumnName, String valueColumnName) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (JsonValue itemsJsonValue : items) {
            JsonObject keyColumn = itemsJsonValue.asJsonObject().getJsonObject(keyColumnName);
            if (keyColumn == null) continue;
            boolean isKeyColumnValueValid = true;
            String keyColumnValue = "";
            for (String keyFieldName : keyColumn.keySet()) {
                if (SUPPORTED_DATA_TYPES.contains(keyFieldName)) {
                    keyColumnValue = ((JsonValue)keyColumn.get((Object)keyFieldName)).toString();
                    continue;
                }
                isKeyColumnValueValid = false;
                DynamoDBConfigSource.printDataTypeNotSupportMessage();
                break;
            }
            if (!isKeyColumnValueValid) continue;
            JsonObject valueColumn = itemsJsonValue.asJsonObject().getJsonObject(valueColumnName);
            String valueColumnValue = "";
            for (String valueFieldName : valueColumn.keySet()) {
                if (SUPPORTED_DATA_TYPES.contains(valueFieldName)) {
                    valueColumnValue = ((JsonValue)valueColumn.get((Object)valueFieldName)).toString();
                    continue;
                }
                DynamoDBConfigSource.printDataTypeNotSupportMessage();
                break;
            }
            results.put(keyColumnValue.replaceAll("^\"|\"$", ""), valueColumnValue.replaceAll("^\"|\"$", ""));
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonArray readItems(InputStream input) {
        try (JsonParser parser = Json.createParser((InputStream)input);){
            block9: {
                while (parser.hasNext()) {
                    JsonParser.Event parseEvent = parser.next();
                    if (parseEvent != JsonParser.Event.KEY_NAME) continue;
                    String keyName = parser.getString();
                    parser.next();
                    if (!"Items".equals(keyName)) {
                        continue;
                    }
                    break block9;
                }
                return null;
            }
            JsonArray jsonArray = parser.getArray();
            return jsonArray;
        }
    }

    @Override
    public String getSource() {
        return "cloud";
    }

    @Override
    public String getName() {
        return "dynamodb";
    }

    @Override
    public int getOrdinal() {
        return Integer.parseInt(this.mpconfig.getCloudOrdinality());
    }

    @Override
    public void destroy() {
        this.builder = null;
    }

    @Override
    public boolean setValue(String name, String value) {
        LOGGER.warning("DynamoDB Config source currently doesn't support setting config property");
        return false;
    }

    @Override
    public boolean deleteValue(String name) {
        LOGGER.warning("DynamoDB Config source currently doesn't support deleting config property");
        return false;
    }

    private static void printMisconfigurationMessage() {
        LOGGER.warning("DynamoDB Config Source isn't configured correctly. Make sure that the password aliases AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY exist.");
    }

    private static void printDataTypeNotSupportMessage() {
        LOGGER.warning("The column you have configured with DynamoDB Config source has attributes that use a data type that is not currently supported. Only the following types are supported: String, Binary, Boolean, Number and Null.");
    }
}

