/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.gcp;

import com.sun.enterprise.util.StringUtils;
import fish.payara.microprofile.config.extensions.gcp.GCPSecretsConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.BaseSetConfigSourceConfigurationCommand;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="set-gcp-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-gcp-config-source-configuration", description="Configures GCP Secrets Config Source")})
public class SetGCPSecretsConfigSourceConfigurationCommand
extends BaseSetConfigSourceConfigurationCommand<GCPSecretsConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(SetGCPSecretsConfigSourceConfigurationCommand.class.getPackage().getName());
    @Param(optional=true, alias="project-name")
    protected String projectName;
    @Param(optional=true, alias="json-key-file")
    private File jsonKeyFile;
    @Inject
    private ServerEnvironment env;

    @Override
    protected void applyValues(ActionReport report, GCPSecretsConfigSourceConfiguration configuration) throws PropertyVetoException {
        super.applyValues(report, configuration);
        if (StringUtils.ok((String)this.projectName)) {
            configuration.setProjectName(this.projectName);
        }
        if (this.jsonKeyFile != null) {
            if (!this.jsonKeyFile.exists() || !this.jsonKeyFile.isFile()) {
                throw new PropertyVetoException("JSON Key file not found", new PropertyChangeEvent(configuration, "jsonKeyFile", null, this.jsonKeyFile));
            }
            try {
                Path configDirPath = this.env.getConfigDirPath().toPath();
                Path output = Files.copy(this.jsonKeyFile.toPath(), configDirPath.resolve(this.jsonKeyFile.getName()), StandardCopyOption.REPLACE_EXISTING);
                configuration.setTokenFilePath(configDirPath.relativize(output).toString());
                LOGGER.info("File copied to " + output);
            }
            catch (IOException e) {
                String message = "Unable to find or access target file";
                LOGGER.log(Level.WARNING, "Unable to find or access target file", e);
                throw new PropertyVetoException("Unable to find or access target file", new PropertyChangeEvent(configuration, "jsonKeyFile", null, this.jsonKeyFile));
            }
        }
    }
}

