/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.policy.MethodLookupUtils;
import fish.payara.microprofile.faulttolerance.policy.Policy;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.util.Objects;
import javassist.Modifier;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class FallbackPolicy
extends Policy {
    public final Class<? extends FallbackHandler<?>> value;
    public final String fallbackMethod;
    public final Method method;
    private final Class<? extends Throwable>[] applyOn;
    private final Class<? extends Throwable>[] skipOn;

    public FallbackPolicy(Method annotated, Class<? extends FallbackHandler<?>> value, String fallbackMethod) {
        this(annotated, value, fallbackMethod, new Class[]{Throwable.class}, new Class[0]);
    }

    public FallbackPolicy(Method annotated, Class<? extends FallbackHandler<?>> value, String fallbackMethod, Class<? extends Throwable>[] applyOn, Class<? extends Throwable>[] skipOn) {
        FallbackPolicy.checkUnambiguous(annotated, value, fallbackMethod);
        this.value = value;
        this.fallbackMethod = fallbackMethod;
        if (fallbackMethod != null && !fallbackMethod.isEmpty()) {
            this.method = MethodLookupUtils.findMethodWithMatchingNameAndArguments(fallbackMethod, annotated);
            if (this.method == null) {
                throw new FaultToleranceDefinitionException(FallbackPolicy.describe(annotated, Fallback.class, "fallbackMethod") + "value referring to a method that is not defined or has a incompatible method signature.");
            }
            FallbackPolicy.checkReturnsSameAs(annotated, Fallback.class, "fallbackMethod", this.method);
            FallbackPolicy.checkAccessible(annotated, this.method);
        } else {
            this.method = null;
        }
        if (this.isHandlerPresent()) {
            FallbackPolicy.checkReturnsSameAs(annotated, Fallback.class, "value", value, "handle", ExecutionContext.class);
        }
        this.applyOn = applyOn;
        this.skipOn = skipOn;
    }

    public static FallbackPolicy create(InvocationContext context, FaultToleranceConfig config) {
        if (config.isAnnotationPresent(Fallback.class) && config.isEnabled(Fallback.class)) {
            Fallback annotation = config.getAnnotation(Fallback.class);
            return new FallbackPolicy(context.getMethod(), config.value(annotation), config.fallbackMethod(annotation), config.applyOn(annotation), config.skipOn(annotation));
        }
        return null;
    }

    private static void checkUnambiguous(Method annotated, Class<? extends FallbackHandler<?>> value, String fallbackMethod) {
        if (fallbackMethod != null && !fallbackMethod.isEmpty() && value != null && value != Fallback.DEFAULT.class) {
            throw new FaultToleranceDefinitionException(FallbackPolicy.describe(annotated, Fallback.class, "") + "defined both a fallback handler and a fallback method.");
        }
    }

    private static void checkAccessible(Method annotated, Method fallback) {
        boolean samePackage = Objects.equals(fallback.getDeclaringClass().getPackage(), annotated.getDeclaringClass().getPackage());
        boolean sameClass = fallback.getDeclaringClass().equals(annotated.getDeclaringClass());
        if (Modifier.isPackage((int)fallback.getModifiers()) && !samePackage || Modifier.isPrivate((int)fallback.getModifiers()) && !sameClass) {
            throw new FaultToleranceDefinitionException(FallbackPolicy.describe(annotated, Fallback.class, "fallbackMethod") + "value referring to a method that is not accessible.");
        }
    }

    public boolean isHandlerPresent() {
        return this.value != null && this.value != Fallback.DEFAULT.class;
    }

    public boolean isFallbackApplied(Throwable ex) {
        return !Policy.isCaught(ex, this.skipOn) && Policy.isCaught(ex, this.applyOn);
    }
}

