/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public final class MethodLookupUtils {
    private MethodLookupUtils() {
    }

    public static Method findMethodWithMatchingNameAndArguments(String name, Method sample) {
        for (Class<?> currentType = sample.getDeclaringClass(); currentType != Object.class; currentType = currentType.getSuperclass()) {
            try {
                Method candidate = currentType.getDeclaredMethod(name, sample.getParameterTypes());
                if (MethodLookupUtils.isMatchingParameterList(sample, candidate)) {
                    return candidate;
                }
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            for (Method method : currentType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || !MethodLookupUtils.isMatchingParameterList(sample, method)) continue;
                return method;
            }
            for (GenericDeclaration genericDeclaration : currentType.getInterfaces()) {
                for (Method candidate : ((Class)genericDeclaration).getDeclaredMethods()) {
                    if (!name.equals(candidate.getName()) || !MethodLookupUtils.isMatchingParameterList(sample, candidate)) continue;
                    return candidate;
                }
            }
        }
        return null;
    }

    private static boolean isMatchingParameterList(Method sample, Method candidate) {
        return MethodLookupUtils.isMatchingParameterList(sample.getGenericParameterTypes(), candidate.getGenericParameterTypes());
    }

    private static boolean isMatchingParameterList(Type[] samples, Type[] candidates) {
        if (samples.length != candidates.length) {
            return false;
        }
        for (int i = 0; i < samples.length; ++i) {
            if (MethodLookupUtils.isMatchingType(samples[i], candidates[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isMatchingType(Type sample, Type candidate) {
        return sample.equals(candidate) || candidate instanceof TypeVariable || candidate instanceof GenericArrayType || MethodLookupUtils.isMatchingGenericType(sample, candidate) || MethodLookupUtils.isMatchingWildcardType(sample, candidate);
    }

    private static boolean isMatchingWildcardType(Type sample, Type candidate) {
        if (sample instanceof WildcardType && candidate instanceof WildcardType) {
            WildcardType sampleType = (WildcardType)sample;
            WildcardType candidateType = (WildcardType)candidate;
            return MethodLookupUtils.isMatchingParameterList(sampleType.getLowerBounds(), candidateType.getLowerBounds()) && MethodLookupUtils.isMatchingParameterList(sampleType.getUpperBounds(), candidateType.getUpperBounds());
        }
        return false;
    }

    private static boolean isMatchingGenericType(Type sample, Type candidate) {
        if (sample instanceof ParameterizedType && candidate instanceof ParameterizedType) {
            ParameterizedType sampleType = (ParameterizedType)sample;
            ParameterizedType candidateType = (ParameterizedType)candidate;
            if (sampleType.getRawType() != candidateType.getRawType()) {
                return false;
            }
            return MethodLookupUtils.isMatchingParameterList(sampleType.getActualTypeArguments(), candidateType.getActualTypeArguments());
        }
        return false;
    }
}

