/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-config-dir")
@PerLookup
@ExecuteOn
@TargetType
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-config-dir", description="Sets the Directory for the Config Source")})
public class SetConfigSecretsDirectory
implements AdminCommand {
    @Param
    String directory;
    @Param(optional=true, defaultValue="server")
    String target;
    @Inject
    Target targetUtil;
    @Inject
    ServerEnvironment env;

    public void execute(AdminCommandContext context) {
        Path directoryPath = Paths.get(this.directory, new String[0]);
        boolean absolute = true;
        boolean relativeFound = false;
        if (!(Files.isDirectory(directoryPath, new LinkOption[0]) && Files.exists(directoryPath, new LinkOption[0]) && Files.isReadable(directoryPath))) {
            absolute = false;
            context.getActionReport().appendMessage("Could not find readable directory at " + directoryPath.toString() + "\n");
            Path instanceRoot = this.env.getInstanceRoot().toPath();
            Path relative = Paths.get(instanceRoot.toString(), this.directory);
            if (!(Files.isDirectory(relative, new LinkOption[0]) && Files.exists(relative, new LinkOption[0]) && Files.isReadable(relative))) {
                context.getActionReport().appendMessage("Could not find readable directory at " + relative.toString() + "\n");
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            relativeFound = true;
            directoryPath = relative;
            context.getActionReport().appendMessage("Using readable directory at " + relative.toString() + "\n");
        } else {
            context.getActionReport().appendMessage("Using readable directory at " + directoryPath.toString() + "\n");
        }
        Config configVal = this.targetUtil.getConfig(this.target);
        MicroprofileConfigConfiguration serviceConfig = (MicroprofileConfigConfiguration)configVal.getExtensionByType(MicroprofileConfigConfiguration.class);
        try {
            final Path toSet = directoryPath;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MicroprofileConfigConfiguration>(){

                public Object run(MicroprofileConfigConfiguration t) throws PropertyVetoException, TransactionFailure {
                    t.setSecretDir(toSet.toString());
                    return null;
                }
            }, (ConfigBeanProxy)serviceConfig);
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(SetConfigSecretsDirectory.class.getName()).log(Level.SEVERE, "Could not set Directory", ex);
            context.getActionReport().failure(Logger.getLogger(this.getClass().getName()), "Could not set Directory", (Throwable)ex);
        }
    }
}

