/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.alert;

import fish.payara.monitoring.alert.Alert;
import fish.payara.monitoring.alert.Condition;
import fish.payara.monitoring.model.Metric;
import fish.payara.monitoring.model.SeriesDataset;
import fish.payara.monitoring.model.SeriesLookup;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.Serializable;

public final class Circumstance
implements Serializable {
    public static final Circumstance UNSPECIFIED = new Circumstance(Alert.Level.WHITE, Condition.NONE, Condition.NONE);
    public final Alert.Level level;
    public final Condition start;
    public final Condition stop;
    public final Condition suppress;
    public final Metric suppressing;

    public Circumstance(Alert.Level level, Condition start) {
        this(level, start, Condition.NONE);
    }

    public Circumstance(Alert.Level level, Condition start, Condition stop) {
        this(level, start, stop, null, Condition.NONE);
    }

    private Circumstance(Alert.Level level, Condition start, Condition stop, Metric suppressing, Condition suppress) {
        this.level = level;
        this.start = start;
        this.stop = stop;
        this.suppressing = suppressing;
        this.suppress = suppress;
        this.ensureOnlyNonExistentHasWhiteLevel();
    }

    private void ensureOnlyNonExistentHasWhiteLevel() {
        if (!(this.level != Alert.Level.WHITE || this.start.isNone() && this.stop.isNone() && this.suppress.isNone())) {
            throw new IllegalArgumentException("Only NON_EXISTENT can have WHITE level");
        }
    }

    public Circumstance suppressedWhen(Metric suppressing, Condition suppress) {
        return new Circumstance(this.level, this.start, this.stop, suppressing, suppress);
    }

    public boolean isUnspecified() {
        return this.level == Alert.Level.WHITE;
    }

    public boolean starts(SeriesDataset data, SeriesLookup lookup) {
        if (this.isUnspecified()) {
            return false;
        }
        if (!this.suppress.isNone()) {
            for (SeriesDataset set : lookup.selectSeries(this.suppressing.series, data.getInstance())) {
                if (!this.suppress.isSatisfied(set)) continue;
                return false;
            }
        }
        return this.start.isSatisfied(data);
    }

    public boolean stops(SeriesDataset data) {
        return this.stop.isNone() ? !this.start.isSatisfied(data) : this.stop.isSatisfied(data);
    }

    public int hashCode() {
        return this.level.hashCode() ^ this.start.hashCode() ^ this.stop.hashCode() ^ this.suppress.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Circumstance && this.equalTo((Circumstance)obj);
    }

    public boolean equalTo(Circumstance other) {
        return this.level == other.level && this.start.equalTo(other.start) && this.stop.equalTo(other.stop) && this.suppress.equalTo(other.suppress) && (this.suppressing == null && other.suppressing == null || this.suppressing != null && this.suppressing.equalTo(other.suppressing));
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.level.name()).append(": ");
        if (!this.start.isNone()) {
            str.append(this.start.toString());
        }
        if (!this.suppress.isNone()) {
            str.append(" unless ").append(this.suppressing.series).append(' ').append(this.suppress.toString());
        }
        if (!this.stop.isNone()) {
            str.append(" until ").append(this.stop.toString());
        }
        return str.toString();
    }

    public JsonValue toJSON() {
        if (this.isUnspecified()) {
            return JsonValue.NULL;
        }
        return Json.createObjectBuilder().add("level", this.level.name().toLowerCase()).add("start", this.start.toJSON()).add("stop", this.stop.toJSON()).add("suppress", this.suppress.toJSON()).add("suppressing", (JsonValue)(this.suppressing == null ? JsonValue.NULL : this.suppressing.toJSON())).build();
    }

    public static Circumstance fromJson(JsonValue value) {
        if (value == JsonValue.NULL || value == null) {
            return UNSPECIFIED;
        }
        JsonObject obj = value.asJsonObject();
        return new Circumstance(Alert.Level.parse(obj.getString("level")), Condition.fromJSON((JsonValue)obj.get((Object)"start")), Condition.fromJSON((JsonValue)obj.get((Object)"stop")), Metric.fromJSON((JsonValue)obj.get((Object)"suppressing")), Condition.fromJSON((JsonValue)obj.get((Object)"suppress")));
    }
}

