/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension;

import fish.payara.appserver.micro.services.PayaraClusteredCDIEventImpl;
import fish.payara.micro.PayaraInstance;
import fish.payara.micro.cdi.ClusteredCDIEventBus;
import fish.payara.micro.cdi.Inbound;
import fish.payara.micro.cdi.Outbound;
import fish.payara.micro.event.CDIEventListener;
import fish.payara.micro.event.PayaraClusteredCDIEvent;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.JavaEEContextUtil;

@ApplicationScoped
public class ClusteredCDIEventBusImpl
implements CDIEventListener,
ClusteredCDIEventBus {
    @Inject
    private PayaraInstance runtime;
    @Inject
    private BeanManager bm;
    private ManagedExecutorService managedExecutorService;
    private JavaEEContextUtil.Instance ctxUtil;
    private static final String INSTANCE_PROPERTY = "InstanceName";
    private static final String EVENT_PROPERTY = "EventName";
    private static final String ITEM_SEPARATOR = ",,,";

    @PostConstruct
    void postConstruct() {
        this.ctxUtil = ((JavaEEContextUtil)Globals.getDefaultHabitat().getService(JavaEEContextUtil.class, new Annotation[0])).currentInvocation();
        try {
            InitialContext ctx = new InitialContext();
            this.managedExecutorService = (ManagedExecutorService)ctx.lookup("java:comp/DefaultManagedExecutorService");
        }
        catch (NamingException ex) {
            throw new RuntimeException(ex);
        }
        this.runtime.addCDIListener((CDIEventListener)this);
        if (this.runtime.isClustered()) {
            Logger.getLogger(ClusteredCDIEventBusImpl.class.getName()).log(Level.INFO, "Clustered CDI Event bus initialized");
        }
    }

    @PreDestroy
    void preDestroy() {
        this.runtime.removeCDIListener((CDIEventListener)this);
    }

    public void onStart(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
    }

    public void initialize() {
    }

    public void eventReceived(final PayaraClusteredCDIEvent event) {
        String instanceName = event.getProperty(INSTANCE_PROPERTY);
        if (instanceName != null && instanceName.length() != 0) {
            String[] names = this.deserializeToArray(instanceName);
            boolean forUs = false;
            String thisInstance = this.runtime.getInstanceName();
            for (String name : names) {
                if (!name.equals(thisInstance)) continue;
                forUs = true;
                break;
            }
            if (!forUs) {
                return;
            }
        }
        try (JavaEEContextUtil.Context ctx = this.ctxUtil.pushContext();){
            this.managedExecutorService.submit(() -> {
                try (JavaEEContextUtil.Context ctx1 = this.ctxUtil.setApplicationClassLoader();){
                    HashSet<Object> qualifiers = new HashSet<Object>();
                    Serializable eventPayload = event.getPayload();
                    Inbound inbound = new Inbound(){

                        public String eventName() {
                            return event.getProperty(ClusteredCDIEventBusImpl.EVENT_PROPERTY);
                        }

                        public Class<? extends Annotation> annotationType() {
                            return Inbound.class;
                        }
                    };
                    qualifiers.add(inbound);
                    Set receivedQualifiers = event.getQualifiers();
                    for (Annotation receivedQualifier : receivedQualifiers) {
                        if (receivedQualifier instanceof Outbound) continue;
                        qualifiers.add(receivedQualifier);
                    }
                    Annotation[] annotations = qualifiers.toArray(new Annotation[0]);
                    this.bm.getEvent().select(annotations).fire((Object)eventPayload);
                }
                catch (IOException | ClassNotFoundException ex) {
                    Logger.getLogger(ClusteredCDIEventBusImpl.class.getName()).log(ex.getCause() instanceof IllegalStateException ? Level.FINE : Level.INFO, "Received Event but could not process it", ex);
                }
            });
        }
    }

    void onOutboundEvent(@Observes @Outbound Serializable event, EventMetadata meta) throws IOException {
        boolean loopBack = false;
        String eventName = "";
        String[] instanceName = new String[]{};
        for (Annotation annotation : meta.getQualifiers()) {
            if (!(annotation instanceof Outbound)) continue;
            Outbound outboundattn = (Outbound)annotation;
            eventName = outboundattn.eventName();
            loopBack = outboundattn.loopBack();
            instanceName = outboundattn.instanceName();
        }
        PayaraClusteredCDIEventImpl clusteredEvent = new PayaraClusteredCDIEventImpl(this.runtime.getLocalDescriptor(), event);
        clusteredEvent.setLoopBack(loopBack);
        clusteredEvent.setProperty(EVENT_PROPERTY, eventName);
        clusteredEvent.setProperty(INSTANCE_PROPERTY, ClusteredCDIEventBusImpl.serializeArray(instanceName));
        Set qualifiers = meta.getQualifiers();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            clusteredEvent.addQualifiers(qualifiers);
        }
        this.runtime.publishCDIEvent((PayaraClusteredCDIEvent)clusteredEvent);
    }

    private static String serializeArray(String[] items) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : items) {
            if (first) {
                first = false;
            } else {
                sb.append(ITEM_SEPARATOR);
            }
            sb.append(name);
        }
        return sb.toString();
    }

    private String[] deserializeToArray(String serializedItems) {
        return serializedItems.split(ITEM_SEPARATOR);
    }
}

