/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.deployment.autodeploy.AutoDeployedFilesManager;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoOperation;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.common.DeploymentProperties;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AutoUndeploymentOperation
extends AutoOperation {
    private static final String COMMAND_NAME = "undeploy";
    @LogMessageInfo(message="Attempt to create file {0} failed; no further information.", level="WARNING")
    private static final String CREATE_FAILED = "NCLS-DEPLOYMENT-02039";
    @Inject
    private Applications apps;
    @Inject
    private AutodeployRetryManager retryManager;
    @Inject
    @Named(value="undeploy")
    private AdminCommand undeployCommand;

    public static AutoUndeploymentOperation newInstance(ServiceLocator serviceLocator, File file, String name, String target) {
        AutoUndeploymentOperation autoUndeploymentOperation = (AutoUndeploymentOperation)serviceLocator.getService(AutoUndeploymentOperation.class, new Annotation[0]);
        autoUndeploymentOperation.init(file, name, target);
        return autoUndeploymentOperation;
    }

    protected AutoUndeploymentOperation init(File appFile, String name, String target) {
        super.init(appFile, this.prepareUndeployActionProperties(name, target), COMMAND_NAME, this.undeployCommand);
        return this;
    }

    private Properties prepareUndeployActionProperties(String archiveName, String target) {
        DeploymentProperties deploymentProperties = new DeploymentProperties();
        String applicationName = archiveName;
        for (Application application : this.apps.getApplications()) {
            String defaultAppName = application.getDeployProperties().getProperty("defaultAppName");
            if (defaultAppName == null || !defaultAppName.equals(archiveName)) continue;
            applicationName = application.getName();
        }
        deploymentProperties.setName(applicationName);
        deploymentProperties.setTarget(target);
        return deploymentProperties;
    }

    @Override
    protected String getMessageString(AutoDeployer.AutodeploymentStatus autodeploymentStatus, File file) {
        return localStrings.getLocalString(autodeploymentStatus.undeploymentMessageKey, autodeploymentStatus.undeploymentDefaultMessage, new Object[]{file});
    }

    @Override
    protected void markFiles(AutoDeployer.AutodeploymentStatus autodeploymentStatus, File file) {
        if (this.undeployedByRequestFile(file)) {
            this.cleanupAppAndRequest(file);
        }
        if (autodeploymentStatus.status) {
            this.markUndeployed(file);
            this.retryManager.recordSuccessfulUndeployment(file);
        } else {
            this.markUndeployFailed(file);
            this.retryManager.recordFailedUndeployment(file);
        }
    }

    private void markUndeployed(File file) {
        try {
            this.deleteAllMarks(file);
            File undeployedFile = this.getUndeployedFile(file);
            if (!undeployedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FAILED, undeployedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void markUndeployFailed(File file) {
        try {
            this.deleteAllMarks(file);
            File undeployFailedFile = this.getUndeployFailedFile(file);
            if (!undeployFailedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FAILED, undeployFailedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean undeployedByRequestFile(File file) {
        return file instanceof AutoDeployedFilesManager.UndeployRequestedFile;
    }

    private void cleanupAppAndRequest(File file) {
        boolean logFine = deplLogger.isLoggable(Level.FINE);
        if (file.isDirectory()) {
            if (logFine) {
                deplLogger.fine("Deleting autodeployed directory " + file.getAbsolutePath() + " by request");
            }
            FileUtils.liquidate((File)file);
        } else {
            if (logFine) {
                deplLogger.fine("Deleting autodeployed file " + file.getAbsolutePath() + " by request");
            }
            FileUtils.deleteFile((File)file);
        }
        File requestFile = AutoDeployedFilesManager.appToUndeployRequestFile(file);
        if (logFine) {
            deplLogger.fine("Deleting autodeploy request file " + requestFile.getAbsolutePath());
        }
        FileUtils.deleteFile((File)requestFile);
    }
}

