/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public final class MetricUtils<T extends Metric> {
    private static final Map<Class<? extends Metric>, MetricUtils<?>> TYPES = new HashMap();
    public static final String TAG_METRIC_MP_SCOPE_NAME = "mp_scope";
    public static final String TAG_METRIC_MP_APP_NAME = "mp_app";
    public static final String METRIC_TAGS_GLOBAL_PROPERTY = "mp.metrics.tags";
    private final ByJust<String, T> byName;
    private final By<String, Tag[], T> byNameAndTags;
    private final By<Metadata, Tag[], T> byMetadataAndTags;

    private MetricUtils(ByJust<String, T> byName, By<String, Tag[], T> byNameAndTags, By<Metadata, Tag[], T> byMetadataAndTags) {
        this.byName = byName;
        this.byNameAndTags = byNameAndTags;
        this.byMetadataAndTags = byMetadataAndTags;
    }

    static <T extends Metric> void register(Class<T> type, ByJust<String, T> byName, By<String, Tag[], T> byNameAndTags, By<Metadata, Tag[], T> byMetadataAndTags) {
        TYPES.put(type, new MetricUtils<T>(byName, byNameAndTags, byMetadataAndTags));
    }

    public static <T extends Metric> T getOrRegisterByName(MetricRegistry registry, Class<T> metric, String name) {
        return (T)((Metric)MetricUtils.getOrRegister(metric).byName.apply(registry, name));
    }

    public static <T extends Metric> T getOrRegisterByNameAndTags(MetricRegistry registry, Class<T> metric, String name, Tag ... tags) {
        return (T)((Metric)MetricUtils.getOrRegister(metric).byNameAndTags.apply(registry, name, tags));
    }

    public static <T extends Metric> T getOrRegisterByMetadataAndTags(MetricRegistry registry, Class<T> metric, Metadata metadata, Tag ... tags) {
        return (T)((Metric)MetricUtils.getOrRegister(metric).byMetadataAndTags.apply(registry, metadata, tags));
    }

    public static Tag[] setScopeTagForMetric(String scope, Tag ... tags) {
        Tag t;
        Tag[] tArray = new Tag[1];
        if (scope.equals("base")) {
            tArray[0] = t = new Tag(TAG_METRIC_MP_SCOPE_NAME, "base");
        } else if (scope.equals("vendor")) {
            tArray[0] = t = new Tag(TAG_METRIC_MP_SCOPE_NAME, "vendor");
        } else if (scope.equals("application")) {
            tArray[0] = t = new Tag(TAG_METRIC_MP_SCOPE_NAME, "application");
        } else if (scope != null) {
            tArray[0] = t = new Tag(TAG_METRIC_MP_SCOPE_NAME, scope);
        }
        Tag[] mergeArray = (Tag[])Stream.concat(Arrays.stream(tags), Arrays.stream(tArray)).toArray(v -> (Tag[])Array.newInstance(tags.getClass().getComponentType(), v));
        return mergeArray;
    }

    private static <T extends Metric> MetricUtils<?> getOrRegister(Class<T> metric) {
        MetricUtils<?> getOrRegister = TYPES.get(metric);
        if (getOrRegister == null) {
            throw new IllegalArgumentException("Cannot get or register metrics of type " + metric);
        }
        return getOrRegister;
    }

    private static Gauge<?> getGauge(MetricRegistry registry, String name) {
        return MetricUtils.getGauge(registry, name, new Tag[0]);
    }

    private static Gauge<?> getGauge(MetricRegistry registry, Metadata metadata, Tag[] tags) {
        return MetricUtils.getGauge(registry, metadata.getName(), tags);
    }

    private static Gauge<?> getGauge(MetricRegistry registry, String name, Tag[] tags) {
        MetricID complementedMetricID = new MetricID(name, tags);
        Gauge gauge = (Gauge)registry.getGauges().get(complementedMetricID);
        return gauge != null ? gauge : new LazyGauge(() -> (Gauge)registry.getGauges().get(complementedMetricID));
    }

    public static Tag[] resolveGlobalTagsConfiguration() {
        Config config = MetricUtils.getConfigProvider();
        if (config != null) {
            Optional<String> globalTags = config.getOptionalValue(METRIC_TAGS_GLOBAL_PROPERTY, String.class);
            if (globalTags.isPresent()) {
                return MetricUtils.parseGlobalTags(globalTags.get());
            }
            return new Tag[0];
        }
        return new Tag[0];
    }

    private static Tag[] parseGlobalTags(String globalTags) {
        if (globalTags == null || globalTags.length() == 0) {
            return new Tag[0];
        }
        String[] keyValuePairs = globalTags.split("(?<!\\\\),");
        Tag[] tagsArray = new Tag[keyValuePairs.length];
        int tagIndex = 0;
        for (String kv : keyValuePairs) {
            if (kv.length() == 0) {
                String message = String.format("Invalid list of global tags, the correct format is: [a-zA-Z_][a-zA-Z0-9_]*. Pleasereview entry %s from global properties", METRIC_TAGS_GLOBAL_PROPERTY);
                throw new IllegalArgumentException(message);
            }
            String[] internalKVSplit = MetricUtils.getInternalKeyValueStrings(kv);
            String key = internalKVSplit[0];
            String value = internalKVSplit[1];
            if (!key.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
                String message = String.format("Invalid tag name. Please review names to follow regex [a-zA-Z_][a-zA-Z0-9_]*. Invalid name %s", key);
                throw new IllegalArgumentException(message);
            }
            value = value.replace("\\,", ",");
            value = value.replace("\\=", "=");
            tagsArray[tagIndex] = new Tag(key, value);
            ++tagIndex;
        }
        return tagsArray;
    }

    private static String[] getInternalKeyValueStrings(String kv) {
        String[] internalKVSplit = kv.split("(?<!\\\\)=");
        if (internalKVSplit.length != 2 || internalKVSplit[0].length() == 0 || internalKVSplit[1].length() == 0) {
            String message = String.format("Invalid individual global tag, the correct format is: [a-zA-Z_][a-zA-Z0-9_]*. Pleasereview entry %s from global properties", METRIC_TAGS_GLOBAL_PROPERTY);
            throw new IllegalArgumentException(message);
        }
        return internalKVSplit;
    }

    public static Config getConfigProvider() {
        try {
            return ConfigProvider.getConfig();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        MetricUtils.register(Counter.class, MetricRegistry::counter, MetricRegistry::counter, MetricRegistry::counter);
        MetricUtils.register(Histogram.class, MetricRegistry::histogram, MetricRegistry::histogram, MetricRegistry::histogram);
        MetricUtils.register(Timer.class, MetricRegistry::timer, MetricRegistry::timer, MetricRegistry::timer);
        MetricUtils.register(Gauge.class, MetricUtils::getGauge, MetricUtils::getGauge, MetricUtils::getGauge);
    }

    private static final class LazyGauge<T extends Number>
    implements Gauge<T> {
        private final AtomicReference<Gauge<T>> gauge = new AtomicReference();
        private final Supplier<Gauge<T>> lookup;

        LazyGauge(Supplier<Gauge<T>> lookup) {
            this.lookup = lookup;
        }

        @Override
        public T getValue() {
            Gauge<T> lazy = this.gauge.updateAndGet(instance -> instance != null ? instance : this.lookup.get());
            return lazy == null ? null : (T)lazy.getValue();
        }
    }

    @FunctionalInterface
    private static interface ByJust<A, R> {
        public R apply(MetricRegistry var1, A var2);
    }

    @FunctionalInterface
    private static interface By<A, B, R> {
        public R apply(MetricRegistry var1, A var2, B var3);
    }
}

