/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.jmx;

import fish.payara.microprofile.metrics.jmx.XmlTag;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.Metadata;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MetricsMetadata
implements Metadata {
    private static final Logger LOGGER = Logger.getLogger(MetricsMetadata.class.getName());
    @XmlElement(name="mbean")
    private String mBean;
    @XmlElement(name="service")
    private String service;
    @XmlElement
    private boolean dynamic = true;
    @XmlElement
    private String name;
    @XmlElement
    private String description;
    @XmlElement
    private String unit;
    @XmlElement
    private String type;
    @XmlTransient
    private Boolean valid;
    @XmlElementWrapper(name="tags", nillable=true)
    @XmlElement(name="tag")
    private List<XmlTag> tags = new ArrayList<XmlTag>();

    public MetricsMetadata() {
    }

    public MetricsMetadata(Metadata metadata) {
        this(null, metadata.getName(), metadata.description().orElse(null), null, metadata.unit().orElse(null));
    }

    public MetricsMetadata(String mBean, String name, String description, String type, String unit) {
        this();
        this.type = type;
        this.mBean = mBean;
        this.name = name;
        this.description = description;
        this.unit = unit;
    }

    public MetricsMetadata(String name, String description, String type, String unit) {
        this();
        this.name = name;
        this.description = description;
        this.type = type;
        this.unit = unit;
    }

    public String getMBean() {
        return this.mBean;
    }

    public void setMBean(String mBean) {
        this.mBean = mBean;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isValid() {
        if (this.valid == null) {
            this.valid = this.validateMetadata();
        }
        return this.valid;
    }

    List<XmlTag> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit == null ? "none" : this.unit;
    }

    @Override
    public Optional<String> unit() {
        return Optional.ofNullable(this.unit);
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private boolean validateMetadata() {
        boolean validationResult = true;
        MetricsMetadata metadata = this;
        if (Objects.isNull(metadata.getName())) {
            LOGGER.log(Level.WARNING, "'name' property not defined in " + metadata.getMBean() + " mbean metadata", new Exception());
            validationResult = false;
        }
        if (Objects.isNull(metadata.getMBean()) && Objects.isNull(metadata.getService())) {
            LOGGER.log(Level.WARNING, "'mbean' or 'service' property not defined in {0} metadata", metadata.getName());
            validationResult = false;
        }
        if (Objects.isNull(metadata.getType())) {
            LOGGER.log(Level.WARNING, "'type' property not defined in {0} metadata", metadata.getName());
            validationResult = false;
        }
        if (Objects.nonNull(metadata.getName()) && Objects.nonNull(metadata.getMBean())) {
            for (String keyword : new String[]{"%s", "${key}", "${attribute}", "${subattribute}"}) {
                if (metadata.getName().contains(keyword) && !metadata.getMBean().contains(keyword)) {
                    LOGGER.log(Level.WARNING, "{0} placeholder not found in 'mbean' {1} property", new String[]{keyword, metadata.getMBean()});
                    validationResult = false;
                    continue;
                }
                if (!metadata.getMBean().contains(keyword)) continue;
                boolean tagSpecifier = false;
                for (XmlTag tag : this.tags) {
                    if (tag.getValue() == null || !tag.getValue().contains(keyword)) continue;
                    tagSpecifier = true;
                    break;
                }
                if (metadata.getName().contains(keyword) || tagSpecifier) continue;
                LOGGER.log(Level.WARNING, "{0} placeholder not found in 'name' {1} property or in tags", new String[]{keyword, metadata.getName()});
                validationResult = false;
            }
        }
        return validationResult;
    }

    public void setTags(List<XmlTag> tags) {
        if (tags == null) {
            throw new IllegalArgumentException("tags must not be null");
        }
        this.tags = tags;
    }

    public void addTags(List<XmlTag> tags) {
        this.tags.addAll(tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getUnit(), that.getUnit());
    }

    public String toString() {
        return new StringJoiner(", ", MetricsMetadata.class.getSimpleName() + "[", "]").add("mBean='" + this.mBean + "'").add("dynamic=" + this.dynamic).add("name='" + this.name + "'").add("description='" + this.description + "'").add("unit='" + this.unit + "'").add("type='" + this.type + "'").add("valid=" + this.valid).add("tags=" + this.tags).toString();
    }
}

