/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.servlet.ServletHandler;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.deployment.util.WebServerInfo;
import org.glassfish.webservices.EjbWSAdapter;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.deployment.WebServiceGrizzlyListenerAdapter;
import org.glassfish.webservices.deployment.WebServiceGrizzlyRestartListener;

public class WebServicesApplication
implements ApplicationContainer<Object>,
WebServiceGrizzlyRestartListener {
    private static final Logger logger = LogUtils.getLogger();
    private ArrayList<EjbEndpoint> ejbendpoints;
    private final ServletHandler httpHandler;
    private final RequestDispatcher dispatcher;
    private final DeploymentContext deploymentCtx;
    private ClassLoader cl;
    private Application app;
    private final Set<String> publishedFiles;
    private String virtualServers;
    private final WebServiceGrizzlyListenerAdapter grizzlyRestartListener;

    public WebServicesApplication(DeploymentContext context, RequestDispatcher dispatcherString, Set<String> publishedFiles) {
        this.deploymentCtx = context;
        this.dispatcher = dispatcherString;
        this.ejbendpoints = this.getEjbEndpoints();
        this.httpHandler = new EjbWSAdapter();
        this.publishedFiles = publishedFiles;
        this.grizzlyRestartListener = (WebServiceGrizzlyListenerAdapter)Globals.getDefaultHabitat().getService(WebServiceGrizzlyListenerAdapter.class, new Annotation[0]);
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        this.cl = startupContext.getClassLoader();
        this.app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
        DeployCommandParameters commandParams = (DeployCommandParameters)((DeploymentContext)startupContext).getCommandParameters(DeployCommandParameters.class);
        this.virtualServers = commandParams.virtualservers;
        this.createEndpoints();
        this.grizzlyRestartListener.addListener(this);
        return true;
    }

    private void createEndpoints() {
        try {
            if (this.app == null || this.cl == null) {
                return;
            }
            for (EjbEndpoint ejbendpoint : this.ejbendpoints) {
                String contextRoot = ejbendpoint.contextRoot;
                WebServerInfo wsi = new WsUtil().getWebServerInfoForDAS();
                URL rootURL = wsi.getWebServerRootURL(ejbendpoint.isSecure);
                this.dispatcher.registerEndpoint(contextRoot, (HttpHandler)this.httpHandler, (ApplicationContainer)this, this.virtualServers);
                if (wsi.getHttpVS() == null || wsi.getHttpVS().getPort() == 0) continue;
                logger.log(Level.INFO, "AS-WSJSR109IMPL-00019", new Object[]{this.app.getAppName(), rootURL + contextRoot});
            }
        }
        catch (MalformedURLException | EndpointRegistrationException e) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00054", e.toString());
        }
    }

    private boolean destroyEndpoints() {
        try {
            for (EjbEndpoint endpoint : this.ejbendpoints) {
                String contextRoot = endpoint.contextRoot;
                this.dispatcher.unregisterEndpoint(contextRoot);
            }
        }
        catch (EndpointRegistrationException e) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00055", e.toString());
            return false;
        }
        return true;
    }

    private ArrayList<EjbEndpoint> getEjbEndpoints() {
        this.ejbendpoints = new ArrayList();
        Application app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
        Set bundles = app.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            this.collectEjbEndpoints(bundle);
        }
        return this.ejbendpoints;
    }

    private void collectEjbEndpoints(BundleDescriptor bundleDesc) {
        WebServicesDescriptor wsDesc = bundleDesc.getWebServices();
        for (WebService ws : wsDesc.getWebServices()) {
            for (WebServiceEndpoint endpoint : ws.getEndpoints()) {
                if (!endpoint.implementedByEjbComponent()) continue;
                this.ejbendpoints.add(new EjbEndpoint(endpoint.getEndpointAddressUri(), endpoint.isSecure()));
            }
        }
    }

    public boolean stop(ApplicationContext stopContext) {
        this.grizzlyRestartListener.removeListener(this);
        return this.destroyEndpoints();
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() throws Exception {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    Application getApplication() {
        return this.app;
    }

    @Override
    public void restartEndpoints() {
        this.destroyEndpoints();
        this.createEndpoints();
    }

    Set<String> getPublishedFiles() {
        return this.publishedFiles;
    }

    static class EjbEndpoint {
        private final String contextRoot;
        private boolean isSecure;

        EjbEndpoint(String contextRoot, boolean secure) {
            this.contextRoot = contextRoot;
            this.isSecure = secure;
        }
    }
}

