/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.instance.admin;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import fish.payara.docker.instance.JsonRequestConstructor;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_create-docker-container")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="_create-docker-container", description="Create a Docker Container for the defined Instance on the specified nodeName")})
public class CreateDockerContainerCommand
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(CreateDockerContainerCommand.class.getName());
    @Param(name="nodeName", alias="node")
    private String nodeName;
    @Param(name="instanceName", alias="instance", primary=true)
    private String instanceName;
    @Inject
    private Servers servers;
    @Inject
    private Nodes nodes;
    @Inject
    private CommandRunner commandRunner;

    public void execute(AdminCommandContext adminCommandContext) {
        ActionReport actionReport = adminCommandContext.getActionReport();
        Node node = this.nodes.getNode(this.nodeName);
        if (node == null) {
            actionReport.failure(logger, "No nodeName found with given name: " + this.nodeName);
            return;
        }
        if (!node.getType().equals("DOCKER")) {
            actionReport.failure(logger, "Node is not of type DOCKER, nodeName is of type: " + node.getType());
            return;
        }
        String dasHost = "";
        String dasPort = "";
        for (Server server : this.servers.getServer()) {
            if (!server.isDas()) continue;
            dasHost = server.getAdminHost();
            dasPort = Integer.toString(server.getAdminPort());
            break;
        }
        if (dasHost == null || dasHost.trim().isEmpty() || dasPort.trim().isEmpty()) {
            actionReport.failure(logger, "Could not retrieve DAS host address or port");
            return;
        }
        Server server = this.servers.getServer(this.instanceName);
        if (server == null) {
            actionReport.failure(logger, "No instance registered in domain with name: " + this.instanceName);
            return;
        }
        this.pullImage(node);
        this.createContainer(adminCommandContext, actionReport, node, server, dasHost, dasPort);
    }

    private void pullImage(Node node) {
        WebTarget webTarget = this.createWebTarget(node, "/images/create");
        webTarget = webTarget.queryParam("fromImage", new Object[]{node.getDockerImage()});
        Response response = null;
        try {
            response = webTarget.queryParam("name", new Object[]{this.instanceName}).request(new String[]{"application/json"}).post(Entity.entity((Object)JsonObject.EMPTY_JSON_OBJECT, (String)"application/json"));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Encountered an exception sending request to Docker: \n", ex);
        }
        if (response != null) {
            Response.StatusType responseStatus = response.getStatusInfo();
            if (!responseStatus.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                logger.fine("Failed to pull Docker Image: \n" + responseStatus.getReasonPhrase());
            }
        } else {
            logger.fine("Failed to pull Docker Image");
        }
    }

    private void createContainer(AdminCommandContext adminCommandContext, ActionReport actionReport, Node node, Server server, String dasHost, String dasPort) {
        Properties containerConfig = new Properties();
        for (SystemProperty systemProperty : server.getSystemProperty()) {
            if (!systemProperty.getName().startsWith("Docker.")) continue;
            containerConfig.put(systemProperty.getName().substring(systemProperty.getName().indexOf(".") + 1), systemProperty.getValue());
        }
        for (SystemProperty systemProperty : server.getConfig().getSystemProperty()) {
            if (!systemProperty.getName().startsWith("Docker.")) continue;
            containerConfig.putIfAbsent(systemProperty.getName().substring(systemProperty.getName().indexOf(".") + 1), systemProperty.getValue());
        }
        JsonObject jsonObject = JsonRequestConstructor.constructJsonRequest(containerConfig, node, server, dasHost, dasPort);
        WebTarget webTarget = this.createWebTarget(node, "/containers/create");
        webTarget = webTarget.queryParam("name", new Object[]{this.instanceName});
        Response response = null;
        try {
            response = webTarget.request(new String[]{"application/json"}).post(Entity.entity((Object)jsonObject, (String)"application/json"));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Encountered an exception sending request to Docker: \n", ex);
        }
        if (response != null) {
            Response.StatusType responseStatus = response.getStatusInfo();
            if (responseStatus.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                JsonObject jsonResponse = (JsonObject)response.readEntity(JsonObject.class);
                if (jsonResponse != null) {
                    String dockerContainerId = jsonResponse.getString("Id");
                    if (dockerContainerId != null && !dockerContainerId.trim().isEmpty()) {
                        this.setDockerContainerId(actionReport, server, dockerContainerId);
                    } else {
                        this.setDockerContainerId(actionReport, server, this.instanceName);
                    }
                }
            } else {
                actionReport.failure(logger, "Failed to create Docker Container: \n" + responseStatus.getReasonPhrase());
                this.unregisterInstance(adminCommandContext, actionReport);
            }
        } else {
            actionReport.failure(logger, "Failed to create Docker Container");
            this.unregisterInstance(adminCommandContext, actionReport);
        }
    }

    private WebTarget createWebTarget(Node node, String endpoint) {
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target((Boolean.parseBoolean(node.getUseTls()) ? "https://" : "http://") + node.getNodeHost() + ":" + node.getDockerPort() + (String)(endpoint.startsWith("/") ? endpoint : "/" + endpoint));
        return webTarget;
    }

    private void setDockerContainerId(ActionReport actionReport, Server server, String dockerContainerId) {
        try {
            ConfigSupport.apply(serverProxy -> {
                serverProxy.setDockerContainerId(dockerContainerId);
                return serverProxy;
            }, (ConfigBeanProxy)server);
        }
        catch (TransactionFailure transactionFailure) {
            actionReport.failure(logger, "Could not set Docker Container ID for instance", (Throwable)transactionFailure);
        }
    }

    private void unregisterInstance(AdminCommandContext adminCommandContext, ActionReport actionReport) {
        if (this.commandRunner != null) {
            actionReport.appendMessage("\n\nWill attempt to unregister instance...");
            ActionReport subActionReport = actionReport.addSubActionsReport();
            CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_unregister-instance", subActionReport, adminCommandContext.getSubject());
            ParameterMap commandParameters = new ParameterMap();
            commandParameters.add((Object)"DEFAULT", (Object)this.instanceName);
            commandInvocation.parameters(commandParameters);
            commandInvocation.execute();
            if (subActionReport.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                actionReport.appendMessage("\nSuccessfully unregistered instance");
            } else {
                actionReport.appendMessage("\nFailed to unregister instance, user intervention will be required");
            }
        }
    }
}

