/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.node.admin;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import jakarta.inject.Inject;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_delete-temp-nodes")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.POST, path="_delete-temp-nodes", description="Deletes all temporary nodes not in use")})
public class DeleteTempNodesCommand
implements AdminCommand {
    @Inject
    private Nodes nodes;
    @Inject
    private Servers servers;
    @Inject
    private CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        for (Node node : this.nodes.getNode()) {
            if (!node.getType().equals("TEMP") || this.commandRunner == null) continue;
            ParameterMap parameterMap = new ParameterMap();
            parameterMap.add((Object)"name", (Object)node.getName());
            if (node.nodeInUse()) {
                this.deleteServersOnNode(node, context);
                continue;
            }
            this.commandRunner.getCommandInvocation("_delete-node-temp", context.getActionReport(), context.getSubject()).parameters(parameterMap).execute();
        }
    }

    private void deleteServersOnNode(Node node, AdminCommandContext context) {
        for (Server server : this.servers.getServersOnNode(node)) {
            ParameterMap parameterMap = new ParameterMap();
            parameterMap.add((Object)"instance_name", (Object)server.getName());
            this.commandRunner.getCommandInvocation("delete-instance", context.getActionReport(), context.getSubject()).parameters(parameterMap).execute();
        }
    }
}

