/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jmx.monitoring.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.jmx.monitoring.JMXMonitoringService;
import jakarta.inject.Inject;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="__enable-jmx-monitoring-service-on-instance")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="__enable.jmx.monitoring.service.on.instance")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="__enable-jmx-monitoring-service-on-instance", description="Enables the JMX Monitoring Service on Instance")})
public class EnableJMXMonitoringServiceOnInstance
implements AdminCommand {
    @Inject
    JMXMonitoringService monitoringService;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        this.monitoringService.setEnabled(this.enabled);
        actionReport.appendMessage(this.monitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.status.success", "Monitoring Service Status is set to {0} on {1}.", new Object[]{this.enabled, this.target}));
    }
}

