/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jmx.monitoring.admin;

import fish.payara.jmx.monitoring.JMXMonitoringService;
import fish.payara.jmx.monitoring.configuration.MonitoringServiceConfiguration;
import jakarta.inject.Inject;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@Service(name="bootstrap-monitoring")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="bootstrap.monitoring")
@RestEndpoints(value={@RestEndpoint(configBean=MonitoringServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="bootstrap-monitoring", description="Bootstraps JMX Monitoring Service")})
public class MonitoringBootstrapper
implements AdminCommand {
    @Inject
    ServerEnvironment server;
    @Inject
    JMXMonitoringService service;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (this.server.isDas()) {
            if (this.targetUtil.getConfig(this.target).isDas()) {
                this.service.bootstrapMonitoringService();
            }
        } else {
            this.service.bootstrapMonitoringService();
        }
    }
}

