/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.cdi.transaction.TransactionScopedCDIUtil;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;

public class TransactionalInterceptorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.cdi.LogMessages";
    @LoggerInfo(subsystem="AS-CDI-JTA", description="CDI-JTA", publish=true)
    public static final String CDI_JTA_LOGGER_SUBSYSTEM_NAME = "javax.enterprise.resource.jta";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");
    @LogMessageInfo(message="Encountered NamingException while attempting to acquire transaction manager for Transactional annotation interceptors {0}", action="Fix the issue for the Naming exception", cause="Transaction annotation processing for the Naming", level="SEVERE")
    public static final String CDI_JTA_NAME_EXCEPTION = "AS-JTA-00001";
    @LogMessageInfo(message="About to setRollbackOnly from @Transactional interceptor on transaction: {0}", level="FINE")
    public static final String CDI_JTA_SETROLLBACK = "AS-JTA-00002";
    @LogMessageInfo(message="No ComponentInvocation present for @Transactional annotation processing. Restriction on use of UserTransaction will not be enforced.", level="WARNING")
    public static final String CDI_JTA_NOCOMPONENT = "AS-JTA-00003";
    @LogMessageInfo(message="In MANDATORY TransactionalInterceptor", level="FINE")
    public static final String CDI_JTA_MANDATORY = "AS-JTA-00004";
    @LogMessageInfo(message="In NEVER TransactionalInterceptor", level="FINE")
    public static final String CDI_JTA_NEVER = "AS-JTA-00005";
    @LogMessageInfo(message="In NOT_SUPPORTED TransactionalInterceptor", level="FINE")
    public static final String CDI_JTA_NOTSUPPORTED = "AS-JTA-00006";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of NOT_SUPPORTED called inside a transaction context. Suspending transaction...", level="FINE")
    public static final String CDI_JTA_MBNOTSUPPORTED = "AS-JTA-00007";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of NOT_SUPPORTED called inside a transaction context.  Suspending transaction failed due to {0}", level="FINE")
    public static final String CDI_JTA_MBNOTSUPPORTEDTX = "AS-JTA-00008";
    @LogMessageInfo(message="In REQUIRED TransactionalInterceptor", level="FINE")
    public static final String CDI_JTA_REQUIRED = "AS-JTA-00009";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of REQUIRED called outside a transaction context.  Beginning a transaction...", level="FINE")
    public static final String CDI_JTA_MBREQUIRED = "AS-JTA-00010";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during begin {0}", level="WARNING")
    public static final String CDI_JTA_MBREQUIREDBT = "AS-JTA-00011";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during commit {0}", level="WARNING")
    public static final String CDI_JTA_MBREQUIREDCT = "AS-JTA-00012";
    @LogMessageInfo(message="In REQUIRES_NEW TransactionalInterceptor", level="FINE")
    public static final String CDI_JTA_REQNEW = "AS-JTA-00013";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of REQUIRES_NEW called inside a transaction context.  Suspending before beginning a transaction...", level="FINE")
    public static final String CDI_JTA_MBREQNEW = "AS-JTA-00014";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during begin {0}", level="WARNING")
    public static final String CDI_JTA_MBREQNEWBT = "AS-JTA-00015";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during commit {0}", level="WARNING")
    public static final String CDI_JTA_MBREQNEWCT = "AS-JTA-00016";
    @LogMessageInfo(message="Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during resume {0}", level="WARNING")
    public static final String CDI_JTA_MBREQNEWRT = "AS-JTA-00017";
    @LogMessageInfo(message="In SUPPORTS TransactionalInterceptor", level="FINE")
    public static final String CDI_JTA_SUPPORTS = "AS-JTA-00018";
    private static TransactionManager testTransactionManager;
    private static volatile TransactionManager transactionManager;
    private transient TransactionOperationsManager preexistingTransactionOperationsManager;
    private static final TransactionOperationsManager transactionalTransactionOperationsManagerTransactionMethodsAllowed;
    private static final TransactionOperationsManager transactionalTransactionOperationsManagerTransactionMethodsNotAllowed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (testTransactionManager != null) {
            return testTransactionManager;
        }
        if (transactionManager == null) {
            try {
                Class<TransactionalInterceptorBase> clazz = TransactionalInterceptorBase.class;
                synchronized (TransactionalInterceptorBase.class) {
                    if (transactionManager == null) {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:appserver/TransactionManager");
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (NamingException e) {
                _logger.log(Level.SEVERE, CDI_JTA_NAME_EXCEPTION, e);
                throw new RuntimeException("Unable to obtain TransactionManager for Transactional Interceptor", e);
            }
        }
        {
            return transactionManager;
        }
    }

    static void setTestTransactionManager(TransactionManager transactionManager) {
        testTransactionManager = transactionManager;
    }

    boolean isLifeCycleMethod(InvocationContext ctx) {
        return ctx.getMethod().getAnnotation(PostConstruct.class) != null || ctx.getMethod().getAnnotation(PreDestroy.class) != null;
    }

    public Object proceed(InvocationContext ctx) throws Exception {
        Object object;
        Transactional transactionalAnnotation = this.getTransactionalAnnotation(ctx);
        Class[] rollbackOn = transactionalAnnotation.rollbackOn();
        Class[] dontRollbackOn = transactionalAnnotation.dontRollbackOn();
        try {
            object = ctx.proceed();
        }
        catch (RuntimeException runtimeException) {
            _logger.log(Level.FINE, "Error during transaction processing", runtimeException);
            Class<?> dontRollbackOnClass = this.getClassInArrayClosestToClassOrNull(dontRollbackOn, runtimeException.getClass());
            if (dontRollbackOnClass == null) {
                this.markRollbackIfActiveTransaction();
                throw runtimeException;
            }
            if (dontRollbackOnClass.equals(runtimeException.getClass()) || dontRollbackOnClass.isAssignableFrom(runtimeException.getClass())) {
                throw runtimeException;
            }
            Class<?> rollbackOnClass = this.getClassInArrayClosestToClassOrNull(rollbackOn, runtimeException.getClass());
            if (rollbackOnClass != null) {
                if (rollbackOnClass.isAssignableFrom(dontRollbackOnClass)) {
                    throw runtimeException;
                }
                if (dontRollbackOnClass.isAssignableFrom(rollbackOnClass)) {
                    this.markRollbackIfActiveTransaction();
                    throw runtimeException;
                }
            }
            this.markRollbackIfActiveTransaction();
            throw runtimeException;
        }
        catch (Exception checkedException) {
            _logger.log(Level.FINE, "Error during transaction processing", checkedException);
            Class<?> rollbackOnClass = this.getClassInArrayClosestToClassOrNull(rollbackOn, checkedException.getClass());
            if (rollbackOnClass == null) {
                throw checkedException;
            }
            Class<?> dontRollbackOnClass = this.getClassInArrayClosestToClassOrNull(dontRollbackOn, checkedException.getClass());
            if (dontRollbackOnClass != null) {
                if (rollbackOnClass.isAssignableFrom(dontRollbackOnClass)) {
                    throw checkedException;
                }
                if (dontRollbackOnClass.isAssignableFrom(rollbackOnClass)) {
                    this.markRollbackIfActiveTransaction();
                    throw checkedException;
                }
            }
            if (rollbackOnClass.equals(checkedException.getClass()) || rollbackOnClass.isAssignableFrom(checkedException.getClass())) {
                this.markRollbackIfActiveTransaction();
                throw checkedException;
            }
            throw checkedException;
        }
        return object;
    }

    private Transactional getTransactionalAnnotation(InvocationContext invocationContext) {
        Optional<Transactional> optionalTransactional;
        Set bindings = (Set)invocationContext.getContextData().get("org.jboss.weld.interceptor.bindings");
        if (bindings != null && (optionalTransactional = bindings.stream().filter(annotation -> annotation.annotationType().equals(Transactional.class)).findAny().map(annotation -> (Transactional)Transactional.class.cast(annotation))).isPresent()) {
            return optionalTransactional.get();
        }
        BeanManager beanManager = CDI.current().getBeanManager();
        optionalTransactional = TransactionScopedCDIUtil.getAnnotation(beanManager, invocationContext.getMethod(), Transactional.class);
        if (optionalTransactional.isPresent()) {
            return optionalTransactional.get();
        }
        optionalTransactional = TransactionScopedCDIUtil.getAnnotation(beanManager, invocationContext.getTarget().getClass(), Transactional.class);
        if (optionalTransactional.isPresent()) {
            return optionalTransactional.get();
        }
        throw new IllegalStateException("@Transactional not found on " + invocationContext.getTarget().getClass());
    }

    private Class<?> getClassInArrayClosestToClassOrNull(Class<?>[] exceptionArray, Class<?> exception) {
        if (exceptionArray == null || exception == null) {
            return null;
        }
        Class<?> closestMatch = null;
        for (Class<?> exceptionArrayElement : exceptionArray) {
            if (exceptionArrayElement.equals(exception)) {
                return exceptionArrayElement;
            }
            if (!exceptionArrayElement.isAssignableFrom(exception) || closestMatch != null && !closestMatch.isAssignableFrom(exceptionArrayElement)) continue;
            closestMatch = exceptionArrayElement;
        }
        return closestMatch;
    }

    private void markRollbackIfActiveTransaction() throws SystemException {
        Transaction transaction = this.getTransactionManager().getTransaction();
        if (transaction != null) {
            _logger.log(Level.FINE, CDI_JTA_SETROLLBACK, transaction);
            this.getTransactionManager().setRollbackOnly();
        }
    }

    void setTransactionalTransactionOperationsManger(boolean userTransactionMethodsAllowed) {
        if (testTransactionManager != null) {
            return;
        }
        ComponentInvocation currentInvocation = this.getCurrentInvocation();
        if (currentInvocation == null) {
            _logger.log(Level.WARNING, CDI_JTA_NOCOMPONENT);
            return;
        }
        this.preexistingTransactionOperationsManager = (TransactionOperationsManager)currentInvocation.getTransactionOperationsManager();
        currentInvocation.setTransactionOperationsManager((Object)(userTransactionMethodsAllowed ? transactionalTransactionOperationsManagerTransactionMethodsAllowed : transactionalTransactionOperationsManagerTransactionMethodsNotAllowed));
    }

    void resetTransactionOperationsManager() {
        if (testTransactionManager != null) {
            return;
        }
        ComponentInvocation currentInvocation = this.getCurrentInvocation();
        if (currentInvocation == null) {
            _logger.log(Level.WARNING, "TransactionalInterceptorBase.markThreadAsTransactional currentInvocation==null");
            return;
        }
        currentInvocation.setTransactionOperationsManager((Object)this.preexistingTransactionOperationsManager);
    }

    ComponentInvocation getCurrentInvocation() {
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        InvocationManager invocationManager = serviceLocator == null ? null : (InvocationManager)serviceLocator.getService(InvocationManager.class, new Annotation[0]);
        return invocationManager == null ? null : invocationManager.getCurrentInvocation();
    }

    static {
        transactionalTransactionOperationsManagerTransactionMethodsAllowed = new TransactionalTransactionOperationsManagerTransactionMethodsAllowed();
        transactionalTransactionOperationsManagerTransactionMethodsNotAllowed = new TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed();
    }

    private static final class TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed
    implements TransactionOperationsManager {
        private TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed() {
        }

        public boolean userTransactionMethodsAllowed() {
            return false;
        }

        public void userTransactionLookupAllowed() throws NameNotFoundException {
        }

        public void doAfterUtxBegin() {
        }
    }

    private static final class TransactionalTransactionOperationsManagerTransactionMethodsAllowed
    implements TransactionOperationsManager {
        private TransactionalTransactionOperationsManagerTransactionMethodsAllowed() {
        }

        public boolean userTransactionMethodsAllowed() {
            return true;
        }

        public void userTransactionLookupAllowed() throws NameNotFoundException {
        }

        public void doAfterUtxBegin() {
        }
    }
}

