/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.hk2.api.ServiceLocator;

public class InjectionPointHelper {
    private final ServiceLocator services;
    private final ComponentEnvManager compEnvManager;
    private final GlassfishNamingManager namingManager;

    public InjectionPointHelper(ServiceLocator h) {
        this.services = h;
        this.compEnvManager = (ComponentEnvManager)this.services.getService(ComponentEnvManager.class, new Annotation[0]);
        this.namingManager = (GlassfishNamingManager)this.services.getService(GlassfishNamingManager.class, new Annotation[0]);
    }

    public Object resolveInjectionPoint(Member member, Application app) throws NamingException {
        Annotation[] annotations;
        if (member == null) {
            throw new IllegalArgumentException("Member cannot be null.");
        }
        if (app == null) {
            throw new IllegalArgumentException("Application cannot be null.");
        }
        Object result = null;
        Field field = null;
        Method method = null;
        if (member instanceof Field) {
            field = (Field)member;
            annotations = field.getDeclaredAnnotations();
        } else if (member instanceof Method) {
            method = (Method)member;
            annotations = method.getDeclaredAnnotations();
        } else {
            throw new IllegalArgumentException("Member must be Field or Method");
        }
        Annotation envAnnotation = this.getEnvAnnotation(annotations);
        if (envAnnotation == null) {
            throw new IllegalArgumentException("No Java EE env dependency annotation found on " + member);
        }
        String envAnnotationName = null;
        try {
            Method m = envAnnotation.annotationType().getDeclaredMethod("name", new Class[0]);
            envAnnotationName = (String)m.invoke((Object)envAnnotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid annotation : must have name() attribute " + envAnnotation.toString(), e);
        }
        Object envDependencyName = envAnnotationName;
        Class<?> declaringClass = member.getDeclaringClass();
        if (envAnnotationName == null || envAnnotationName.equals("")) {
            envDependencyName = field != null ? declaringClass.getName() + "/" + field.getName() : declaringClass.getName() + "/" + this.getInjectionMethodPropertyName(method);
        }
        if (envAnnotationName != null && envAnnotationName.startsWith("java:global/")) {
            Context ic = this.namingManager.getInitialContext();
            result = ic.lookup(envAnnotationName);
        } else {
            BundleDescriptor matchingBundle = null;
            for (BundleDescriptor bundle : app.getBundleDescriptors()) {
                if (bundle instanceof EjbBundleDescriptor || bundle instanceof WebBundleDescriptor) {
                    JndiNameEnvironment jndiEnv = (JndiNameEnvironment)bundle;
                    for (InjectionCapable next : jndiEnv.getInjectableResourcesByClass(declaringClass.getName())) {
                        if (!next.getComponentEnvName().equals(envDependencyName)) continue;
                        matchingBundle = bundle;
                        break;
                    }
                }
                if (matchingBundle == null) continue;
                break;
            }
            if (matchingBundle == null) {
                throw new IllegalArgumentException("Cannot find matching env dependency for " + member + " in Application " + app.getAppName());
            }
            String componentId = this.compEnvManager.getComponentEnvId((JndiNameEnvironment)matchingBundle);
            Object lookupName = ((String)envDependencyName).startsWith("java:") ? envDependencyName : "java:comp/env/" + (String)envDependencyName;
            result = this.namingManager.lookup(componentId, (String)lookupName);
        }
        return result;
    }

    private String getInjectionMethodPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.length() <= 3 || !methodName.startsWith("set")) {
            throw new IllegalArgumentException("Illegal env dependency setter name" + method.getName());
        }
        String propertyName = methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4);
        return propertyName;
    }

    private Annotation getEnvAnnotation(Annotation[] annotations) {
        Annotation envAnnotation = null;
        for (Annotation next : annotations) {
            String className = next.annotationType().getName();
            if (!className.equals("jakarta.ejb.EJB") && !className.equals("jakarta.annotation.Resource") && !className.equals("jakarta.persistence.PersistenceContext") && !className.equals("jakarta.persistence.PersistenceUnit") && !className.equals("jakarta.xml.ws.WebServiceRef")) continue;
            envAnnotation = next;
            break;
        }
        return envAnnotation;
    }
}

