/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.util.Utility;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.internal.api.Globals;
import org.jboss.weld.executor.AbstractExecutorServices;
import org.jboss.weld.manager.api.ExecutorServices;

public class ExecutorServicesImpl
extends AbstractExecutorServices
implements ExecutorServices {
    private final ExecutorService taskExecutor;
    private final ContextualTimerExecutor timerExecutor;
    private final ManagedExecutorService executor;
    private final org.glassfish.concurrent.config.ManagedExecutorService config;
    private static final String DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE = "java:comp/DefaultManagedScheduledExecutorService";
    private static final String DEFAULT_MANAGED_EXECUTOR_SERVICE = "java:comp/DefaultManagedExecutorService";
    private static final String DEFAULT_MANAGED_EXECUTOR_SERVICE_PHYS = "concurrent/__defaultManagedExecutorService";

    public ExecutorServicesImpl() throws NamingException {
        InitialContext ctx = new InitialContext();
        this.executor = (ManagedExecutorService)ctx.lookup(DEFAULT_MANAGED_EXECUTOR_SERVICE);
        this.taskExecutor = new ContextualTaskExecutor();
        this.timerExecutor = new ContextualTimerExecutor();
        this.config = this.getManagedExecutorServiceConfig(DEFAULT_MANAGED_EXECUTOR_SERVICE_PHYS);
    }

    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public ScheduledExecutorService getTimerExecutor() {
        return this.timerExecutor;
    }

    public void cleanup() {
    }

    protected int getThreadPoolSize() {
        return Integer.parseInt(this.config.getMaximumPoolSize());
    }

    public <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        ClassLoader TCCL = Thread.currentThread().getContextClassLoader();
        ArrayList<Callable<T>> wrapped = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrapped.add(ExecutorServicesImpl.inContextClassloader(TCCL, task));
        }
        return wrapped;
    }

    private static <V> Callable<V> inContextClassloader(ClassLoader contextClassLoader, Callable<V> task) {
        return () -> {
            ClassLoader old = Utility.setContextClassLoader((ClassLoader)contextClassLoader);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)old);
            }
        };
    }

    private static Runnable inContextClassloader(ClassLoader contextClassLoader, Runnable task) {
        return () -> {
            ClassLoader old = Utility.setContextClassLoader((ClassLoader)contextClassLoader);
            try {
                task.run();
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)old);
            }
        };
    }

    private static <V> Callable<V> inCurrentContextClassloader(Callable<V> task) {
        return ExecutorServicesImpl.inContextClassloader(Thread.currentThread().getContextClassLoader(), task);
    }

    private static Runnable inCurrentContextClassloader(Runnable task) {
        return ExecutorServicesImpl.inContextClassloader(Thread.currentThread().getContextClassLoader(), task);
    }

    private org.glassfish.concurrent.config.ManagedExecutorService getManagedExecutorServiceConfig(String jndiName) {
        for (org.glassfish.concurrent.config.ManagedExecutorService service : Globals.getDefaultHabitat().getAllServices(org.glassfish.concurrent.config.ManagedExecutorService.class, new Annotation[0])) {
            if (!service.getJndiName().equals(jndiName)) continue;
            return service;
        }
        throw new IllegalStateException(jndiName + " executor service config not found.");
    }

    class ContextualTimerExecutor
    extends ContextualTaskExecutor
    implements ScheduledExecutorService {
        private final ScheduledExecutorService delegate;

        ContextualTimerExecutor() throws NamingException {
            InitialContext ctx = new InitialContext();
            this.delegate = (ManagedScheduledExecutorService)ctx.lookup(ExecutorServicesImpl.DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE);
        }

        @Override
        protected ScheduledExecutorService delegate() {
            return this.delegate;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.delegate().schedule(ExecutorServicesImpl.inCurrentContextClassloader(command), delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.delegate().schedule(ExecutorServicesImpl.inCurrentContextClassloader(callable), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate().scheduleAtFixedRate(ExecutorServicesImpl.inCurrentContextClassloader(command), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate().scheduleWithFixedDelay(ExecutorServicesImpl.inCurrentContextClassloader(command), initialDelay, delay, unit);
        }
    }

    class ContextualTaskExecutor
    implements ExecutorService {
        private final ExecutorService delegate;

        ContextualTaskExecutor() {
            this.delegate = ExecutorServicesImpl.this.executor;
        }

        @Override
        public void shutdown() {
            throw new IllegalStateException("Downstream service cannot request shutdown");
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new IllegalStateException("Downstream service cannot request shutdown");
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate().awaitTermination(timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            return this.delegate().isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate().isTerminated();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.delegate().submit(ExecutorServicesImpl.inCurrentContextClassloader(task));
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.delegate().submit(ExecutorServicesImpl.inCurrentContextClassloader(task), result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.delegate().submit(ExecutorServicesImpl.inCurrentContextClassloader(task));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate().invokeAll(ExecutorServicesImpl.this.wrap(tasks));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate().invokeAll(ExecutorServicesImpl.this.wrap(tasks), timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate().invokeAny(ExecutorServicesImpl.this.wrap(tasks));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate().invokeAny(ExecutorServicesImpl.this.wrap(tasks), timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.delegate().execute(ExecutorServicesImpl.inCurrentContextClassloader(command));
        }

        protected ExecutorService delegate() {
            return this.delegate;
        }
    }
}

