/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class GFLogRecord
extends LogRecord {
    private static final String FAST_LOGGER_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.fastLogging";
    @Deprecated(forRemoval=true, since="6.21.0")
    public static Boolean fastLogging = Boolean.parseBoolean(LogManager.getLogManager().getProperty("com.sun.enterprise.server.logging.GFFileHandler.fastLogging"));
    public static final AtomicBoolean fastLoggingAtomic = new AtomicBoolean(Boolean.parseBoolean(LogManager.getLogManager().getProperty("com.sun.enterprise.server.logging.GFFileHandler.fastLogging")));
    private static final long serialVersionUID = -818792012235891720L;
    private String threadName;

    public GFLogRecord(Level level, String msg) {
        super(level, msg);
    }

    public GFLogRecord(LogRecord record) {
        this(record.getLevel(), record.getMessage());
        this.setLoggerName(record.getLoggerName());
        this.setMillis(record.getMillis());
        this.setParameters(GFLogRecord.transformParameters(record.getParameters()));
        this.setResourceBundle(record.getResourceBundle());
        this.setResourceBundleName(record.getResourceBundleName());
        this.setSequenceNumber(record.getSequenceNumber());
        this.setSourceClassName(record.getSourceClassName());
        this.setSourceMethodName(record.getSourceMethodName());
        this.setThreadID(record.getThreadID());
        this.setThrown(record.getThrown());
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public static GFLogRecord wrap(LogRecord record, boolean setThreadName) {
        GFLogRecord wrappedRecord = record instanceof GFLogRecord ? (GFLogRecord)record : new GFLogRecord(record);
        if (setThreadName && wrappedRecord.getThreadName() == null) {
            wrappedRecord.setThreadName(Thread.currentThread().getName());
        }
        return wrappedRecord;
    }

    private static Object[] transformParameters(Object[] params) {
        if (params == null) {
            return null;
        }
        if (fastLoggingAtomic.get()) {
            return params;
        }
        Object[] result = new Object[params.length * 2];
        System.arraycopy(params, 0, result, params.length, params.length);
        int stringParamsIndex = 0;
        int originalParamsIndex = params.length;
        while (stringParamsIndex < params.length) {
            Object param = params[stringParamsIndex];
            if (param != null) {
                result[stringParamsIndex] = param.toString();
            }
            ++stringParamsIndex;
            ++originalParamsIndex;
        }
        return result;
    }
}

