/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import com.sun.common.util.logging.LoggingConfig;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.common.util.logging.SortedLoggingProperties;
import com.sun.enterprise.util.PropertyPlaceholderHelper;
import jakarta.inject.Inject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;

@Service
@Contract
public class LoggingConfigImpl
implements LoggingConfig {
    static final String GF_FILE_HANDLER = "com.sun.enterprise.server.logging.GFFileHandler";
    static final String PY_FILE_HANDLER = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler";
    protected static final Map<String, String> DEFAULT_LOG_PROPERTIES = new HashMap<String, String>();
    @Inject
    private FileMonitoring fileMonitoring;
    private String target;
    private final Properties props = new Properties();
    private final String loggingPropertiesName;
    private final File loggingConfigDir;
    private final File defaultLogFile;

    @Inject
    public LoggingConfigImpl(ServerEnvironmentImpl env) {
        this(env.getConfigDirPath(), env.getConfigDirPath());
    }

    public LoggingConfigImpl(File defaultConfigDir, File configDir) {
        this.loggingConfigDir = configDir;
        this.loggingPropertiesName = "logging.properties";
        this.defaultLogFile = new File(defaultConfigDir, "default-logging.properties");
    }

    @Override
    public void initialize(String target) throws IOException {
        this.target = target;
    }

    private void loadLoggingProperties() throws IOException {
        this.props.clear();
        File file = this.getLoggingPropertiesFile();
        try (BufferedInputStream fis = new BufferedInputStream(this.getInputStream(file));){
            this.props.load(fis);
        }
    }

    private InputStream getInputStream(File file) throws IOException {
        FileInputStream fileInputStream = !file.exists() ? this.getDefaultLoggingPropertiesInputStream() : new FileInputStream(file);
        return fileInputStream;
    }

    private File getLoggingPropertiesFile() {
        if (this.target == null || this.target.isEmpty()) {
            return new File(this.loggingConfigDir, this.loggingPropertiesName);
        }
        String pathForLoggingFile = this.loggingConfigDir.getAbsolutePath() + File.separator + this.target;
        return new File(pathForLoggingFile, "logging.properties");
    }

    private FileInputStream getDefaultLoggingPropertiesInputStream() throws IOException {
        return new FileInputStream(this.defaultLogFile);
    }

    private void closePropFile() throws IOException {
        File file = this.getLoggingPropertiesFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException();
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            new SortedLoggingProperties(this.props).store(os, "GlassFish logging.properties list");
            ((OutputStream)os).flush();
            this.fileMonitoring.fileModified(file);
        }
    }

    private void setWebLoggers(String value) {
        this.props.setProperty("org.apache.catalina.level", value);
        this.props.setProperty("org.apache.coyote.level", value);
        this.props.setProperty("org.glassfish.wasp.level", value);
    }

    @Override
    public synchronized String setLoggingProperty(String propertyName, String propertyValue) throws IOException {
        this.loadLoggingProperties();
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        if (propertyName.contains("javax.enterprise.system.container.web")) {
            this.setWebLoggers(propertyValue);
        }
        this.closePropFile();
        return property;
    }

    @Override
    public synchronized Map<String, String> setLoggingProperties(Map<String, String> properties) throws IOException {
        this.loadLoggingProperties();
        Map<String, String> m = this.getMap(properties);
        this.closePropFile();
        return m;
    }

    private Map<String, String> getMap(Map<String, String> properties) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (e.getValue() == null) continue;
            String key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
            if (key == null) {
                key = e.getKey();
            }
            String property = (String)this.props.setProperty(key, e.getValue());
            if (e.getKey().contains("javax.enterprise.system.container.web")) {
                this.setWebLoggers(new PropertyPlaceholderHelper(System.getenv(), "([^\\$]*)\\$\\{ENV=([^\\}]*)\\}([^\\$]*)").replacePlaceholder(e.getValue()));
            }
            m.put(key, new PropertyPlaceholderHelper(System.getenv(), "([^\\$]*)\\$\\{ENV=([^\\}]*)\\}([^\\$]*)").replacePlaceholder(property));
        }
        return m;
    }

    @Override
    public String getLoggingProperty(String propertyName) throws IOException {
        return this.getLoggingProperties().get(propertyName);
    }

    @Override
    public synchronized Map<String, String> getLoggingProperties() throws IOException {
        return this.getLoggingProperties(true);
    }

    @Override
    public synchronized Map<String, String> getLoggingProperties(boolean usePlaceholderReplacement) throws IOException {
        this.loadLoggingProperties();
        Enumeration<?> e = this.props.propertyNames();
        Map<String, String> m = this.getMap(e, usePlaceholderReplacement);
        return this.checkForLoggingProperties(m);
    }

    private Map<String, String> getMap(Enumeration<?> e, boolean usePlaceholderReplacement) {
        HashMap<String, String> m = new HashMap<String, String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            String value = usePlaceholderReplacement ? new PropertyPlaceholderHelper(System.getenv(), "([^\\$]*)\\$\\{ENV=([^\\}]*)\\}([^\\$]*)").replacePlaceholder(this.props.getProperty(key)) : this.props.getProperty(key);
            m.put(key, value);
        }
        return m;
    }

    public synchronized Map<String, String> checkForLoggingProperties(Map<String, String> loggingProperties) throws IOException {
        for (Map.Entry<String, String> entry : DEFAULT_LOG_PROPERTIES.entrySet()) {
            if (loggingProperties.containsKey(entry.getKey())) continue;
            loggingProperties.put(entry.getKey(), entry.getValue());
            this.setLoggingProperty(entry.getKey(), entry.getValue());
        }
        return loggingProperties;
    }

    @Override
    public synchronized Map<String, String> deleteLoggingProperties(Map<String, String> properties) throws IOException {
        this.loadLoggingProperties();
        this.remove(properties);
        this.closePropFile();
        this.checkForLoggingProperties(this.getLoggingProperties());
        return properties;
    }

    private void remove(Map<String, String> properties) {
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
            if (key == null) {
                key = e.getKey();
            }
            if (key.contains("\\:")) {
                key = key.replace("\\:", ":");
            }
            this.props.remove(key);
        }
    }

    private String getZipFileName(String sourceDir) {
        String DATE_FORMAT_NOW = "yyyy-MM-dd_HH-mm-ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String currentTime = sdf.format(cal.getTime());
        return sourceDir + File.separator + "log_" + currentTime + ".zip";
    }

    private String getZipFileName(String sourceDir, String fileName) {
        String DATE_FORMAT_NOW = "yyyy-MM-dd_HH-mm-ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String currentTime = sdf.format(cal.getTime());
        return sourceDir + File.separator + fileName + "-" + currentTime + ".zip";
    }

    @Override
    public String createZipFile(String sourceDir) throws IOException {
        String zipFile = this.getZipFileName(sourceDir);
        this.add(sourceDir, zipFile);
        return zipFile;
    }

    private void add(String sourceDir, String zipFile) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(zipFile);
             ZipOutputStream zout = new ZipOutputStream(fout);){
            File fileSource = new File(sourceDir);
            this.addDirectory(zout, fileSource, fileSource.getAbsolutePath().length() + 1);
        }
        catch (IOException ioe) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
            throw ioe;
        }
    }

    public String createZipFile(String sourceDir, String zipFileName) throws IOException {
        String zipFile = this.getZipFileName(sourceDir, zipFileName);
        this.add(sourceDir, zipFile);
        return zipFile;
    }

    private void addDirectory(ZipOutputStream zout, File fileSource, int ignoreLength) throws IOException {
        File[] files = fileSource.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.addDirectory(zout, file, ignoreLength);
                    continue;
                }
                if (file.getAbsolutePath().contains(".zip")) continue;
                try (FileInputStream fin = new FileInputStream(file.getAbsolutePath());){
                    int length;
                    byte[] buffer = new byte[1024];
                    zout.putNextEntry(new ZipEntry(ignoreLength > -1 ? file.getAbsolutePath().substring(ignoreLength) : file.getAbsolutePath()));
                    while ((length = fin.read(buffer)) > 0) {
                        zout.write(buffer, 0, length);
                    }
                    zout.closeEntry();
                }
                catch (IOException ioe) {
                    Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                    throw ioe;
                }
            }
        }
    }

    @Override
    public synchronized String getLoggingFileDetails() throws IOException {
        this.loadLoggingProperties();
        Enumeration<?> loggingPropertyNames = this.props.propertyNames();
        while (loggingPropertyNames.hasMoreElements()) {
            String key = (String)loggingPropertyNames.nextElement();
            if ((key = LoggingXMLNames.xmltoPropsMap.getOrDefault(key, key)) == null || !key.equals("com.sun.enterprise.server.logging.GFFileHandler.file")) continue;
            return this.props.getProperty(key);
        }
        return this.props.getProperty("java.util.logging.FileHandler.pattern");
    }

    static {
        DEFAULT_LOG_PROPERTIES.put("com.sun.enterprise.server.logging.GFFileHandler.logtoFile", "true");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.logtoFile", "true");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.rotationOnDateChange", "false");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.rotationTimelimitInMinutes", "0");
        DEFAULT_LOG_PROPERTIES.put("com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes", "2000000");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.rotationLimitInBytes", "2000000");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.maxHistoryFiles", "0");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.file", "${com.sun.aas.instanceRoot}/logs/notification.log");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.compressOnRotation", "false");
        DEFAULT_LOG_PROPERTIES.put("com.sun.enterprise.server.logging.GFFileHandler.logStandardStreams", "true");
        DEFAULT_LOG_PROPERTIES.put("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.formatter", "com.sun.enterprise.server.logging.ODLLogFormatter");
        DEFAULT_LOG_PROPERTIES.put("com.sun.enterprise.server.logging.GFFileHandler.fastLogging", "false");
    }
}

