/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import com.sun.common.util.logging.BooleanLatch;
import com.sun.common.util.logging.GFLogRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private static final int MAX_RECORDS = 5000;
    private final String lineSeparator;
    private Logger logger;
    private final Level level;
    private final ThreadLocal reentrant = new ThreadLocal();
    private final BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private final BooleanLatch done = new BooleanLatch();
    private Thread pump;

    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.lineSeparator();
        this.initializePump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        String logMessage = null;
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            logMessage = this.toString(StandardCharsets.UTF_8);
            super.reset();
        }
        if (logMessage.trim().length() == 0 || logMessage.trim().equals(this.lineSeparator)) {
            return;
        }
        LogRecord logRecord = new LogRecord(this.level, logMessage);
        GFLogRecord logRecordWrapper = new GFLogRecord(logRecord);
        logRecordWrapper.setThreadName(Thread.currentThread().getName());
        this.pendingRecords.offer(logRecordWrapper);
    }

    private void initializePump() {
        this.pump = new Thread(){

            @Override
            public void run() {
                while (!LoggingOutputStream.this.done.isSignalled()) {
                    try {
                        LoggingOutputStream.this.log();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.pump.setName("Logging output pump");
        this.pump.setDaemon(true);
        this.pump.start();
    }

    public void log() {
        try {
            LogRecord record = this.pendingRecords.take();
            if (this.reentrant.get() != null) {
                return;
            }
            try {
                this.reentrant.set(this);
                this.logger.log(record);
            }
            finally {
                this.reentrant.set(null);
            }
        }
        catch (InterruptedException e) {
            return;
        }
        ArrayList v = new ArrayList();
        int size = this.pendingRecords.size();
        int msgs = this.pendingRecords.drainTo(v, size);
        for (int j = 0; j < msgs; ++j) {
            this.logger.log((LogRecord)v.get(j));
        }
    }

    @Override
    public void close() throws IOException {
        this.done.tryReleaseShared(1);
        this.pump.interrupt();
        int size = this.pendingRecords.size();
        if (size > 0) {
            ArrayList records = new ArrayList(size);
            this.pendingRecords.drainTo(records, size);
            for (LogRecord record : records) {
                this.logger.log(record);
            }
        }
        super.close();
    }

    private static class StackTraceObjects {
        private final ByteArrayOutputStream stackTraceBuf = new ByteArrayOutputStream();
        private final PrintStream stStream = new PrintStream((OutputStream)this.stackTraceBuf, true, StandardCharsets.UTF_8);
        private final String stString;
        private final ByteArrayOutputStream comparisonBuf = new ByteArrayOutputStream();
        private final PrintStream cbStream = new PrintStream((OutputStream)this.comparisonBuf, true, StandardCharsets.UTF_8);
        private int stackTraceBufBytes = 0;
        private int charsIgnored = 0;

        private StackTraceObjects(Throwable x) {
            x.printStackTrace(this.stStream);
            this.stString = this.stackTraceBuf.toString(StandardCharsets.UTF_8);
            this.stackTraceBufBytes = this.stackTraceBuf.size();
            this.cbStream.println(x);
        }

        public String toString() {
            return this.stString;
        }

        boolean ignorePrintln(String str) {
            this.cbStream.println(str);
            String cbString = this.comparisonBuf.toString(StandardCharsets.UTF_8);
            int cbLen = cbString.length();
            if (this.stString.regionMatches(this.charsIgnored, cbString, 0, cbLen)) {
                this.charsIgnored += cbLen;
                this.comparisonBuf.reset();
                return true;
            }
            return false;
        }

        boolean checkCompletion() {
            return this.charsIgnored >= this.stackTraceBufBytes;
        }
    }

    public class LoggingPrintStream
    extends PrintStream {
        LogManager logManager;
        private ThreadLocal<StackTraceObjects> perThreadStObjects;

        public LoggingPrintStream(ByteArrayOutputStream os) {
            super((OutputStream)os, true, StandardCharsets.UTF_8);
            this.logManager = LogManager.getLogManager();
            this.perThreadStObjects = new ThreadLocal();
        }

        public void setLogger(Logger l) {
            LoggingOutputStream.this.logger = l;
        }

        @Override
        public void println(Object x) {
            if (!this.checkLocks()) {
                return;
            }
            if (!(x instanceof Throwable)) {
                this.println(String.valueOf(x));
            } else {
                StackTraceObjects sTO = new StackTraceObjects((Throwable)x);
                this.perThreadStObjects.set(sTO);
                super.println(sTO.toString());
            }
        }

        @Override
        public PrintStream printf(String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            try (Formatter formatter = new Formatter(sb, Locale.getDefault());){
                formatter.format(str, args);
            }
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream printf(Locale locale, String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            try (Formatter formatter = new Formatter(sb, locale);){
                formatter.format(str, args);
            }
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            try (Formatter formatter = new Formatter(sb, Locale.getDefault());){
                formatter.format(Locale.getDefault(), format, args);
            }
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream format(Locale locale, String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            try (Formatter formatter = new Formatter(sb, locale);){
                formatter.format(locale, format, args);
            }
            this.print(sb.toString());
            return null;
        }

        @Override
        public void println(String str) {
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects sTO = this.perThreadStObjects.get();
            if (sTO == null) {
                super.println(str);
                return;
            }
            if (!sTO.ignorePrintln(str)) {
                this.perThreadStObjects.set(null);
                super.println(str);
                return;
            }
            if (sTO.checkCompletion()) {
                this.perThreadStObjects.set(null);
                return;
            }
        }

        @Override
        public void print(String x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void print(Object x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void print(boolean x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(boolean x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(char x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(char x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(int x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(int x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(long x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(long x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(float x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(float x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(double x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(double x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(char[] x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(char[] x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void println() {
            if (this.checkLocks()) {
                super.println();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int off, int len) {
            try {
                LoggingPrintStream loggingPrintStream = this;
                synchronized (loggingPrintStream) {
                    if (this.out == null) {
                        throw new IOException("Stream closed");
                    }
                    this.out.write(buf, off, len);
                    if (len <= 8129) {
                        this.out.flush();
                    }
                }
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException x) {
                this.setError();
            }
        }

        @Override
        public void write(int b) {
            if (this.checkLocks()) {
                super.write(b);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkLocks() {
            Thread t = Thread.currentThread();
            if (Thread.holdsLock(LoggingOutputStream.this.logger)) return false;
            if (Thread.holdsLock(this.logManager)) return false;
            return true;
        }
    }
}

