/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.glassfish;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ASenvPropertyReader {
    private static Map<String, String> envToPropMap = new HashMap<String, String>();
    private static final HashMap<File, ASenvMap> propsMap = new HashMap();
    private ASenvMap props;

    public ASenvPropertyReader() {
        this(GFLauncherUtils.getInstallDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASenvPropertyReader(File installDir) {
        envToPropMap.put("AS_H2_INSTALL", "fish.payara.aas.h2Root");
        envToPropMap.put("AS_IMQ_LIB", "com.sun.aas.imqLib");
        envToPropMap.put("AS_IMQ_BIN", "com.sun.aas.imqBin");
        envToPropMap.put("AS_CONFIG", "com.sun.aas.configRoot");
        envToPropMap.put("AS_INSTALL", "com.sun.aas.installRoot");
        envToPropMap.put("AS_JAVA", "com.sun.aas.javaRoot.asenv");
        envToPropMap.put("AS_DEF_DOMAINS_PATH", "com.sun.aas.domainsRoot");
        envToPropMap.put("AS_DEF_NODES_PATH", "com.sun.aas.agentRoot");
        HashMap<File, ASenvMap> hashMap = propsMap;
        synchronized (hashMap) {
            try {
                installDir = SmartFile.sanitize(installDir);
                this.props = propsMap.get(installDir);
                if (this.props == null) {
                    this.props = new ASenvMap(installDir);
                    propsMap.put(installDir, this.props);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = this.props.keySet();
        for (String key : keys) {
            sb.append(key).append("=").append(this.props.get(key)).append('\n');
        }
        return sb.toString();
    }

    static class ASenvMap
    extends HashMap<String, String> {
        boolean foundToken = false;

        ASenvMap(File installDir) {
            this.put("com.sun.aas.installRoot", installDir.getPath());
            File configDir = SmartFile.sanitize(new File(installDir, "config"));
            this.put("com.sun.aas.configRoot", configDir.getPath());
            this.setProperties(configDir);
            this.postProcess(configDir);
            File installRoot = new File((String)super.get("com.sun.aas.installRoot"));
            this.put("com.sun.aas.productRoot", installRoot.getParent());
        }

        @Override
        public String get(Object k) {
            String v = (String)super.get(k);
            if (v != null) {
                return v;
            }
            if (k.equals("com.sun.aas.hostName")) {
                v = ASenvMap.getHostname();
                this.put("com.sun.aas.hostName", v);
            } else if (k.equals("com.sun.aas.javaRoot")) {
                v = ASenvMap.getJavaRoot((String)super.get("com.sun.aas.javaRoot.asenv"));
                this.put("com.sun.aas.javaRoot", v);
            }
            return v;
        }

        @Override
        public Set<String> keySet() {
            this.completeMap();
            return super.keySet();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            this.completeMap();
            return super.entrySet();
        }

        @Override
        public boolean containsKey(Object k) {
            this.completeMap();
            return super.containsKey((String)k);
        }

        @Override
        public Collection<String> values() {
            this.completeMap();
            return super.values();
        }

        private void completeMap() {
            this.get("com.sun.aas.hostName");
            this.get("com.sun.aas.javaRoot");
        }

        private void postProcess(File configDir) {
            if (this.foundToken) {
                Map<String, String> env = System.getenv();
                HashMap<String, String> all = new HashMap<String, String>(env);
                all.putAll(this);
                TokenResolver tr = new TokenResolver(all);
                tr.resolve(this);
            }
            Set keys = super.keySet();
            for (String key : keys) {
                String value = (String)super.get(key);
                if (!GFLauncherUtils.isRelativePath(value)) continue;
                File f = value.startsWith(".") ? SmartFile.sanitize(new File(configDir, value)) : SmartFile.sanitize(new File(value));
                this.put(key, f.getPath());
            }
        }

        private void setProperties(File configDir) {
            File asenv = new File(configDir, GFLauncherUtils.isWindows() ? "asenv.bat" : "asenv.conf");
            try (BufferedReader reader = new BufferedReader(new FileReader(asenv, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.setProperty(line);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void setProperty(String line) {
            int pos = line.indexOf(61);
            if (pos > 0) {
                String lhs = line.substring(0, pos).trim();
                String rhs = line.substring(pos + 1).trim();
                if (GFLauncherUtils.isWindows()) {
                    lhs = lhs.substring(3).trim();
                } else {
                    pos = rhs.indexOf(34);
                    if (pos != -1 && (pos = (rhs = rhs.substring(pos + 1).trim()).indexOf(34)) != -1) {
                        rhs = rhs.substring(0, pos).trim();
                    }
                }
                String systemPropertyName = envToPropMap.get(lhs);
                if (systemPropertyName != null) {
                    if (TokenResolver.hasToken(rhs)) {
                        this.foundToken = true;
                    }
                    this.put(systemPropertyName, rhs);
                }
            }
        }

        private static String getHostname() {
            String hostname = "localhost";
            try {
                hostname = NetUtils.getCanonicalHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hostname;
        }

        private static String getJavaRoot(String fileValue) {
            Object javaRootName = fileValue;
            if (ASenvMap.isValidJavaRoot((String)javaRootName)) {
                return javaRootName;
            }
            javaRootName = System.getenv("JAVA_HOME");
            if (ASenvMap.isValidJavaRoot((String)javaRootName)) {
                javaRootName = SmartFile.sanitize(new File((String)javaRootName)).getPath();
                return javaRootName;
            }
            javaRootName = System.getProperty("java.home") + "/..";
            if (ASenvMap.isValidJavaRoot((String)javaRootName)) {
                javaRootName = SmartFile.sanitize(new File((String)javaRootName)).getPath();
                return javaRootName;
            }
            javaRootName = System.getProperty("java.home");
            if (ASenvMap.isValidJavaRoot((String)javaRootName)) {
                javaRootName = SmartFile.sanitize(new File((String)javaRootName)).getPath();
                return javaRootName;
            }
            return null;
        }

        private static boolean isValidJavaRoot(String javaRootName) {
            if (!GFLauncherUtils.ok(javaRootName)) {
                return false;
            }
            File f = new File(javaRootName);
            f = GFLauncherUtils.isWindows() ? new File(f, "bin/java.exe") : new File(f, "bin/java");
            return f.exists();
        }
    }
}

