/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.xml;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.universal.xml.ParsedCluster;
import com.sun.enterprise.universal.xml.SysPropsHandler;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.JDK;
import com.sun.enterprise.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MiniXmlParser {
    private static final Logger LOGGER = Logger.getLogger(MiniXmlParser.class.getName());
    private static final String DEFAULT_ADMIN_VS_ID = "__asadmin";
    private static final String DEFAULT_VS_ID = "server";
    private static final String CLUSTERS = "clusters";
    private static final String INVALID = "invalid";
    private static final String PROPERTY = "property";
    private static final String SYSTEM_PROPERTY = "system-property";
    private LoggingConfigImpl loggingConfig;
    private File domainXml;
    private XMLStreamReader parser;
    private InputStreamReader reader;
    private String serverName;
    private String configRef;
    private List<JvmOption> jvmOptions = new ArrayList<JvmOption>();
    private List<String> profilerJvmOptions = new ArrayList<String>();
    private Map<String, String> javaConfig;
    private Map<String, String> profilerConfig = Collections.emptyMap();
    private Map<String, String> profilerSysProps = new HashMap<String, String>();
    private boolean valid = false;
    private List<HostAndPort> adminAddresses = new ArrayList<HostAndPort>();
    private String domainName;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MiniXmlParser.class);
    private boolean monitoringEnabled = true;
    private String adminRealm = null;
    private Map<String, String> adminRealmProperties = null;
    private List<Map<String, String>> vsAttributes = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> listenerAttributes = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> protocolAttributes = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> iiopSslAttributes = new ArrayList<Map<String, String>>();
    private boolean sawNetworkConfig;
    private boolean sawDefaultConfig;
    private boolean sawConfig;
    private SysPropsHandler sysProps = new SysPropsHandler();
    private List<ParsedCluster> clusters = null;
    private boolean secureAdminEnabled = false;

    public MiniXmlParser(File domainXml) throws MiniXmlParserException {
        this(domainXml, DEFAULT_VS_ID);
    }

    public MiniXmlParser(File domainXml, String serverName) throws MiniXmlParserException {
        this.serverName = serverName;
        this.domainXml = domainXml;
        try {
            this.read();
            if (!this.sawConfig) {
                throw new EndDocumentException();
            }
            this.valid = true;
        }
        catch (EndDocumentException e) {
            throw new MiniXmlParserException(strings.get("enddocument", this.configRef, serverName));
        }
        catch (Exception e) {
            throw new MiniXmlParserException(strings.get("toplevel", e), e);
        }
        finally {
            try {
                if (this.parser != null) {
                    this.parser.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Problem closing parser", e);
            }
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Problem closing parser", e);
            }
        }
    }

    public Map<String, String> getJavaConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.javaConfig;
    }

    public List<JvmOption> getJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.jvmOptions;
    }

    public Map<String, String> getProfilerConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.profilerConfig;
    }

    public List<String> getProfilerJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.profilerJvmOptions;
    }

    public Map<String, String> getProfilerSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.profilerSysProps;
    }

    public Map<String, String> getSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.sysProps.getCombinedSysProps();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<HostAndPort> getAdminAddresses() {
        if (this.adminAddresses == null || this.adminAddresses.isEmpty()) {
            String[] listenerNames = this.getListenerNamesForVS(DEFAULT_ADMIN_VS_ID, this.vsAttributes);
            if (listenerNames == null || listenerNames.length == 0) {
                listenerNames = this.getListenerNamesForVS(DEFAULT_VS_ID, this.vsAttributes);
            }
            this.addPortsForListeners(listenerNames);
        }
        return this.adminAddresses;
    }

    public List<Map<String, String>> getProtocolAttributes() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.protocolAttributes;
    }

    public List<Map<String, String>> getIiopSslAttributes() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get(INVALID));
        }
        return this.iiopSslAttributes;
    }

    @Deprecated
    public void setupConfigDir(File configDir, File installDir) {
        this.loggingConfig = new LoggingConfigImpl(configDir, configDir);
    }

    public void setupConfigDir(File configDir) {
        this.loggingConfig = new LoggingConfigImpl(configDir, configDir);
    }

    public boolean getSecureAdminEnabled() {
        return this.secureAdminEnabled;
    }

    public String getLogFilename() {
        String logFilename = null;
        try {
            Map<String, String> map = this.loggingConfig.getLoggingProperties();
            String logFileContains = "${com.sun.aas.instanceName}";
            logFilename = map.get("com.sun.enterprise.server.logging.GFFileHandler.file");
            if (logFilename != null && logFilename.contains(logFileContains)) {
                logFilename = MiniXmlParser.replaceOld(logFilename, logFileContains, this.serverName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return logFilename;
    }

    public String getInstanceLogFilename() {
        String logFilename = null;
        try {
            this.loggingConfig.initialize(this.configRef);
            Map<String, String> map = this.loggingConfig.getLoggingProperties();
            String logFileContains = "${com.sun.aas.instanceName}";
            logFilename = map.get("com.sun.enterprise.server.logging.GFFileHandler.file");
            if (logFilename != null && logFilename.contains(logFileContains)) {
                logFilename = MiniXmlParser.replaceOld(logFilename, logFileContains, this.serverName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return logFilename;
    }

    private static String replaceOld(String aInput, String aOldPattern, String aNewPattern) {
        StringBuilder result = new StringBuilder();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = aInput.indexOf(aOldPattern, startIdx)) >= 0) {
            result.append(aInput.substring(startIdx, idxOld));
            result.append(aNewPattern);
            startIdx = idxOld + aOldPattern.length();
        }
        result.append(aInput.substring(startIdx));
        return result.toString();
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public boolean hasNetworkConfig() {
        return this.sawNetworkConfig;
    }

    public boolean hasDefaultConfig() {
        return this.sawDefaultConfig;
    }

    public String getAdminRealmName() {
        return this.adminRealm;
    }

    public Map<String, String> getAdminRealmProperties() {
        return this.adminRealmProperties;
    }

    private void read() throws XMLStreamException, EndDocumentException, FileNotFoundException {
        this.createParser();
        this.getConfigRefName();
        try {
            this.getConfig();
            this.findOtherStuff();
        }
        catch (EndDocumentException ex) {
            this.createParser();
            this.skipRoot("domain");
            this.getConfig();
            this.findOtherStuff();
            Logger.getLogger(MiniXmlParser.class.getName()).log(Level.FINE, strings.get("secondpass"));
        }
        this.finalTouches();
    }

    private void createParser() throws FileNotFoundException, XMLStreamException {
        this.reader = new InputStreamReader((InputStream)new FileInputStream(this.domainXml), StandardCharsets.UTF_8);
        XMLInputFactory xif = this.getXmlInputFactory();
        xif.setXMLResolver(new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                return new ByteArrayInputStream(new byte[0]);
            }
        });
        this.parser = xif.createXMLStreamReader(this.domainXml.toURI().toString(), this.reader);
    }

    private XMLInputFactory getXmlInputFactory() {
        return XMLInputFactory.newInstance();
    }

    private void getConfigRefName() throws XMLStreamException, EndDocumentException {
        if (this.configRef != null) {
            return;
        }
        this.skipRoot("domain");
        block10: while (true) {
            this.skipTo("servers", PROPERTY, CLUSTERS, SYSTEM_PROPERTY);
            String name = this.parser.getLocalName();
            if (null == name) {
                this.parseDomainProperty();
                continue;
            }
            switch (name) {
                case "servers": {
                    break block10;
                }
                case "clusters": {
                    this.parseClusters();
                    break;
                }
                case "system-property": {
                    this.parseSystemProperty(SysPropsHandler.Type.DOMAIN);
                    break;
                }
                default: {
                    this.parseDomainProperty();
                }
            }
        }
        while (true) {
            this.skipNonStartElements();
            String localName = this.parser.getLocalName();
            if (!DEFAULT_VS_ID.equals(localName)) {
                throw new XMLStreamException(strings.get("noserver", this.serverName));
            }
            Map<String, String> map = this.parseAttributes();
            String thisName = map.get("name");
            if (this.serverName.equals(thisName)) {
                this.configRef = map.get("config-ref");
                this.parseSysPropsFromServer();
                this.skipToEnd("servers");
                return;
            }
            this.skipToEnd(DEFAULT_VS_ID);
        }
    }

    private void getConfig() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipTo("configs", PROPERTY, CLUSTERS, SYSTEM_PROPERTY);
            String name = this.parser.getLocalName();
            if ("configs".equals(name)) break;
            if (CLUSTERS.equals(name)) {
                this.parseClusters();
                continue;
            }
            if (SYSTEM_PROPERTY.equals(name)) {
                this.parseSystemProperty(SysPropsHandler.Type.DOMAIN);
                continue;
            }
            this.parseDomainProperty();
        }
        while (this.skipToButNotPast("configs", "config")) {
            Map<String, String> map = this.parseAttributes();
            String thisName = map.get("name");
            if ("default-config".equals(thisName)) {
                this.sawDefaultConfig = true;
            }
            if (this.configRef.equals(thisName)) {
                this.sawConfig = true;
                this.parseConfig();
                continue;
            }
            this.skipTree("config");
        }
    }

    private void parseConfig() throws XMLStreamException, EndDocumentException {
        block20: while (true) {
            String name;
            int event;
            if ((event = this.next()) == 2) {
                if (!"config".equals(this.parser.getLocalName())) continue;
                return;
            }
            if (event != 1 || null == (name = this.parser.getLocalName())) continue;
            switch (name) {
                case "system-property": {
                    this.parseSystemProperty(SysPropsHandler.Type.CONFIG);
                    continue block20;
                }
                case "java-config": {
                    this.parseJavaConfig();
                    continue block20;
                }
                case "http-service": {
                    this.parseHttpService();
                    continue block20;
                }
                case "network-config": {
                    this.sawNetworkConfig = true;
                    this.parseNetworkConfig();
                    continue block20;
                }
                case "monitoring-service": {
                    this.parseMonitoringService();
                    continue block20;
                }
                case "admin-service": {
                    this.parseAdminService();
                    continue block20;
                }
                case "security-service": {
                    this.populateAdminRealmProperties();
                    continue block20;
                }
                case "iiop-service": {
                    this.parseIiopService();
                    continue block20;
                }
            }
            this.skipTree(name);
        }
    }

    private void parseSecureAdmin() {
        String value;
        Map<String, String> secureAdminProperties = this.parseAttributes();
        if (secureAdminProperties.containsKey("enabled") && "true".equals(value = secureAdminProperties.get("enabled"))) {
            this.secureAdminEnabled = true;
        }
    }

    private void parseNetworkConfig() throws XMLStreamException, EndDocumentException {
        block8: while (true) {
            String name;
            int event;
            if ((event = this.next()) == 2) {
                if (!"network-config".equals(this.parser.getLocalName())) continue;
                return;
            }
            if (event != 1 || null == (name = this.parser.getLocalName())) continue;
            switch (name) {
                case "protocols": {
                    this.parseProtocols();
                    continue block8;
                }
                case "network-listeners": {
                    this.parseListeners();
                    continue block8;
                }
            }
            this.skipTree(name);
        }
    }

    private void parseIiopService() throws XMLStreamException, EndDocumentException {
        while (true) {
            String name;
            int event;
            if ((event = this.next()) == 2) {
                if (!"iiop-service".equals(this.parser.getLocalName())) continue;
                return;
            }
            if (event != 1 || null == (name = this.parser.getLocalName())) continue;
            if (name.equals("iiop-listener")) {
                Map<String, String> iiopAttributes = this.parseAttributes();
                while (true) {
                    this.skipToButNotPast("iiop-listener", "ssl");
                    name = this.parser.getLocalName();
                    if ("ssl".equals(name)) {
                        iiopAttributes.putAll(this.parseAttributes());
                        this.iiopSslAttributes.add(iiopAttributes);
                        continue;
                    }
                    if ("iiop-listener".equals(name)) break;
                }
                continue;
            }
            this.skipTree(name);
        }
    }

    private void parseSysPropsFromServer() throws XMLStreamException, EndDocumentException {
        while (true) {
            int event;
            if ((event = this.next()) == 2) {
                if (!DEFAULT_VS_ID.equals(this.parser.getLocalName())) continue;
                return;
            }
            if (event != 1) continue;
            String name = this.parser.getLocalName();
            if (SYSTEM_PROPERTY.equals(name)) {
                this.parseSystemProperty(SysPropsHandler.Type.SERVER);
                continue;
            }
            this.skipTree(name);
        }
    }

    private void parseSystemProperty(SysPropsHandler.Type type) {
        Map<String, String> map = this.parseAttributes();
        String name = map.get("name");
        String value = map.get("value");
        if (name != null) {
            this.sysProps.add(type, name, value);
        }
    }

    private void parseJavaConfig() throws XMLStreamException, EndDocumentException {
        this.javaConfig = this.parseAttributes();
        this.parseJvmAndProfilerOptions();
    }

    private void parseJvmAndProfilerOptions() throws XMLStreamException, EndDocumentException {
        while (this.skipToButNotPast("java-config", "jvm-options", "profiler")) {
            if ("jvm-options".equals(this.parser.getLocalName())) {
                this.jvmOptions.add(new JvmOption(this.parser.getElementText()));
                continue;
            }
            this.parseProfiler();
        }
    }

    private void parseProfiler() throws XMLStreamException, EndDocumentException {
        this.profilerConfig = this.parseAttributes();
        if (!this.profilerConfig.containsKey("enabled")) {
            this.profilerConfig.put("enabled", "true");
        }
        while (this.skipToButNotPast("profiler", "jvm-options", PROPERTY)) {
            if ("jvm-options".equals(this.parser.getLocalName())) {
                this.profilerJvmOptions.add(this.parser.getElementText());
                continue;
            }
            this.parseProperty(this.profilerSysProps);
        }
    }

    private void parseProperty(Map<String, String> map) {
        Map<String, String> prop = this.parseAttributes();
        String name = prop.get("name");
        String value = prop.get("value");
        if (name != null) {
            map.put(name, value);
        }
    }

    private void skipNonStartElements() throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 1) {
        }
    }

    private void skipRoot(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 1) {
        }
        if (!name.equals(this.parser.getLocalName())) {
            throw new XMLStreamException("Unknown Domain XML Layout");
        }
    }

    private void skipTo(String ... namesArgs) throws XMLStreamException, EndDocumentException {
        List<String> names = Arrays.asList(namesArgs);
        while (true) {
            this.skipNonStartElements();
            String localName = this.parser.getLocalName();
            if (names.contains(localName)) {
                return;
            }
            this.skipTree(localName);
        }
    }

    private boolean skipToButNotPast(String endName, String ... startNames) throws XMLStreamException, EndDocumentException {
        int event;
        do {
            if ((event = this.next()) != 1) continue;
            for (String s : startNames) {
                if (!this.parser.getLocalName().equals(s)) continue;
                return true;
            }
        } while (event != 2 || !this.parser.getLocalName().equals(endName));
        return false;
    }

    private void skipTree(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    private void skipToEnd(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    private int next() throws XMLStreamException, EndDocumentException {
        int event = this.parser.next();
        if (event == 8) {
            this.parser.close();
            throw new EndDocumentException();
        }
        return event;
    }

    private void findOtherStuff() {
        try {
            while (this.skipToButNotPast("domain", PROPERTY, CLUSTERS, SYSTEM_PROPERTY, "secure-admin")) {
                String name = this.parser.getLocalName();
                if (null == name) continue;
                switch (name) {
                    case "clusters": {
                        this.parseClusters();
                        break;
                    }
                    case "system-property": {
                        this.parseSystemProperty(SysPropsHandler.Type.DOMAIN);
                        break;
                    }
                    case "property": {
                        this.parseDomainProperty();
                        break;
                    }
                    case "secure-admin": {
                        this.parseSecureAdmin();
                        break;
                    }
                }
            }
            if (this.domainName == null) {
                Logger.getLogger(MiniXmlParser.class.getName()).log(Level.INFO, strings.get("noDomainName"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(strings.get("noDomainEnd"));
        }
    }

    private void parseDomainProperty() {
        if (this.domainName != null) {
            return;
        }
        Map<String, String> map = this.parseAttributes();
        String name = map.get("name");
        String value = map.get("value");
        if (name == null || value == null) {
            return;
        }
        if ("administrative.domain.name".equals(name)) {
            this.domainName = value;
        }
    }

    private void parseMonitoringService() {
        String s = this.parseAttributes().get("monitoring-enabled");
        this.monitoringEnabled = s == null ? true : !"false".equals(s);
    }

    private void parseAdminService() throws XMLStreamException, EndDocumentException {
        Map<String, String> attributes = null;
        this.skipToButNotPast("admin-service", "jmx-connector");
        String name = this.parser.getLocalName();
        if ("jmx-connector".equals(name)) {
            attributes = this.parseAttributes();
            this.adminRealm = attributes.get("auth-realm-name");
        }
    }

    private void populateAdminRealmProperties() throws XMLStreamException, EndDocumentException {
        if (this.adminRealm == null || this.adminRealmProperties != null) {
            return;
        }
        Map<String, String> attributes = null;
        while (true) {
            this.skipToButNotPast("security-service", "auth-realm");
            String name = this.parser.getLocalName();
            if ("auth-realm".equals(name)) {
                attributes = this.parseAttributes();
                if (!attributes.get("name").equals(this.adminRealm)) continue;
                this.adminRealmProperties = new HashMap<String, String>();
                this.adminRealmProperties.put("classname", attributes.get("classname"));
                while (true) {
                    this.skipToButNotPast("auth-realm", PROPERTY);
                    if (PROPERTY.equals(this.parser.getLocalName())) {
                        attributes = this.parseAttributes();
                        this.adminRealmProperties.put(attributes.get("name"), attributes.get("value"));
                        continue;
                    }
                    if ("auth-realm".equals(this.parser.getLocalName())) break;
                }
                continue;
            }
            if ("security-service".equals(name)) break;
        }
    }

    private void parseHttpService() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipToButNotPast("http-service", "http-listener", "virtual-server");
            String name = this.parser.getLocalName();
            if ("http-listener".equals(name)) {
                this.listenerAttributes.add(this.parseAttributes());
                continue;
            }
            if ("virtual-server".equals(name)) {
                this.vsAttributes.add(this.parseAttributes());
                continue;
            }
            if ("http-service".equals(name)) break;
        }
        String[] listenerNames = this.getListenerNamesForVS(DEFAULT_ADMIN_VS_ID, this.vsAttributes);
        if (listenerNames == null || listenerNames.length == 0) {
            listenerNames = this.getListenerNamesForVS(DEFAULT_VS_ID, this.vsAttributes);
        }
        if (listenerNames == null || listenerNames.length <= 0) {
            return;
        }
        this.addPortsForListeners(listenerNames);
    }

    private void parseListeners() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipToButNotPast("network-listeners", "network-listener");
            String name = this.parser.getLocalName();
            if ("network-listener".equals(name)) {
                this.listenerAttributes.add(this.parseAttributes());
                continue;
            }
            if ("network-listeners".equals(name)) break;
        }
    }

    private void parseProtocols() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipToButNotPast("protocols", "protocol", "ssl");
            String name = this.parser.getLocalName();
            if ("protocol".equals(name)) {
                this.protocolAttributes.add(this.parseAttributes());
                continue;
            }
            if ("ssl".equals(name)) {
                this.protocolAttributes.get(this.protocolAttributes.size() - 1).putAll(this.parseAttributes());
                continue;
            }
            if ("protocols".equals(name)) break;
        }
    }

    private String[] getListenerNamesForVS(String vsid, List<Map<String, String>> vsAttributes) {
        String listeners = null;
        String[] listenerArray = null;
        for (Map<String, String> atts : vsAttributes) {
            String id = atts.get("id");
            if (id == null || !id.equals(vsid)) continue;
            listeners = atts.get("network-listeners");
            if (listeners != null) break;
            listeners = atts.get("http-listeners");
            break;
        }
        if (GFLauncherUtils.ok(listeners) && (listenerArray = listeners.split(",")).length == 0) {
            listenerArray = null;
        }
        return listenerArray;
    }

    private void addPortsForListeners(String[] listenerNames) {
        if (listenerNames != null && listenerNames.length > 0) {
            block0: for (Map<String, String> atts : this.listenerAttributes) {
                String id = atts.get("name");
                if (id == null) {
                    id = atts.get("id");
                }
                if (id == null) continue;
                for (String listenerName : listenerNames) {
                    if (!id.equals(listenerName)) continue;
                    int port = this.getPort(atts.get("port"));
                    if (port < 0) continue block0;
                    String addr = atts.get("address");
                    if (!GFLauncherUtils.ok(addr)) {
                        addr = "localhost";
                    }
                    if (StringUtils.isToken(addr)) {
                        addr = this.sysProps.get(StringUtils.stripToken(addr));
                    }
                    boolean secure = false;
                    String protocol = atts.get("protocol");
                    if ((atts = this.getProtocolByName(protocol)) != null) {
                        String sec = atts.get("security-enabled");
                        boolean bl = secure = sec != null && "true".equalsIgnoreCase(sec);
                    }
                    if (!GFLauncherUtils.ok(addr)) continue block0;
                    this.adminAddresses.add(new HostAndPort(addr, port, secure));
                    continue block0;
                }
            }
        }
    }

    private int getPort(String portString) {
        int port = -1;
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            try {
                portString = this.sysProps.get(StringUtils.stripToken(portString));
                if (portString != null && portString.length() > 0) {
                    port = Integer.parseInt(portString);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return port;
    }

    Map<String, String> getProtocolByName(String name) {
        for (Map<String, String> atts : this.protocolAttributes) {
            String id = atts.get("name");
            if (id == null) {
                id = atts.get("id");
            }
            if (id == null || !id.equals(name)) continue;
            return atts;
        }
        return null;
    }

    private Map<String, String> parseAttributes() {
        int num = this.parser.getAttributeCount();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            map.put(this.parser.getAttributeName(i).getLocalPart(), this.parser.getAttributeValue(i));
        }
        return map;
    }

    private void parseClusters() throws XMLStreamException, EndDocumentException {
        this.clusters = new ArrayList<ParsedCluster>();
        while (this.skipToButNotPast(CLUSTERS, "cluster")) {
            ParsedCluster pc = new ParsedCluster(this.parseAttributes().get("name"));
            this.clusters.add(pc);
            this.parseCluster(pc);
        }
    }

    private void parseCluster(ParsedCluster pc) throws XMLStreamException, EndDocumentException {
        while (this.skipToButNotPast("cluster", SYSTEM_PROPERTY, "server-ref")) {
            Map<String, String> atts;
            String sname;
            String name = this.parser.getLocalName();
            if (SYSTEM_PROPERTY.equals(name)) {
                this.parseProperty(pc.sysProps);
                continue;
            }
            if (!"server-ref".equals(name) || !GFLauncherUtils.ok(sname = (atts = this.parseAttributes()).get("ref"))) continue;
            pc.serverNames.add(sname);
        }
    }

    private void finalTouches() {
        if (this.clusters == null) {
            return;
        }
        for (ParsedCluster pc : this.clusters) {
            Map<String, String> props = pc.getMySysProps(this.serverName);
            if (props == null) continue;
            this.sysProps.add(SysPropsHandler.Type.CLUSTER, props);
            break;
        }
    }

    private static class EndDocumentException
    extends Exception {
        EndDocumentException() {
        }
    }

    public static class JvmOption {
        public final String option;
        public final Optional<String> vendorOrVM;
        public final Optional<JDK.Version> minVersion;
        public final Optional<JDK.Version> maxVersion;
        private static final Pattern PATTERN = Pattern.compile("^\\[(.*)\\|(.*)\\](.*)");

        public JvmOption(String option) {
            Matcher matcher = PATTERN.matcher(option);
            if (matcher.matches()) {
                if (matcher.group(1).contains("-")) {
                    String[] parts = matcher.group(1).split("-");
                    this.vendorOrVM = Optional.ofNullable(parts[0]);
                    this.minVersion = Optional.ofNullable(JDK.getVersion(parts[1]));
                } else {
                    this.vendorOrVM = Optional.empty();
                    this.minVersion = Optional.ofNullable(JDK.getVersion(matcher.group(1)));
                }
                this.maxVersion = Optional.ofNullable(JDK.getVersion(matcher.group(2)));
                this.option = matcher.group(3);
            } else {
                this.option = option;
                this.vendorOrVM = Optional.empty();
                this.minVersion = Optional.empty();
                this.maxVersion = Optional.empty();
            }
        }

        public JvmOption(String option, String minVersion, String maxVersion) {
            this.option = option;
            if (minVersion != null && minVersion.contains("-")) {
                String[] parts = minVersion.split("-");
                this.vendorOrVM = Optional.ofNullable(parts[0]);
                this.minVersion = Optional.ofNullable(JDK.getVersion(parts[1]));
            } else {
                this.vendorOrVM = Optional.empty();
                this.minVersion = Optional.ofNullable(JDK.getVersion(minVersion));
            }
            this.maxVersion = Optional.ofNullable(JDK.getVersion(maxVersion));
        }

        public static boolean hasVersionPattern(String option) {
            return PATTERN.matcher(option).matches();
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.option);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JvmOption other = (JvmOption)obj;
            return Objects.equals(this.option, other.option);
        }

        public String toString() {
            if (!this.minVersion.isPresent() && !this.maxVersion.isPresent()) {
                return this.option;
            }
            return String.format("[%s%s|%s]%s", this.vendorOrVM.isPresent() ? this.vendorOrVM.get() + "-" : "", this.minVersion.isPresent() ? this.minVersion.get() : "", this.maxVersion.isPresent() ? this.maxVersion.get() : "", this.option);
        }
    }
}

