/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.EjbSecurityPolicyProbeProvider;
import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.ee.SecurityContainer;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.jacc.JaccWebAuthorizationManager;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.HAUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="Security")
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication>
implements PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(SecurityDeployer.class, (String)"javax.enterprise.system.core.security");
    @Inject
    private SecurityLifecycle securityLifecycle;
    @Inject
    private ServerContext serverContext;
    @Inject
    @Named(value="webSecurityCIH")
    private Provider<RegisteredComponentInvocationHandler> registeredComponentInvocationHandlerProvider;
    @Inject
    private Provider<Events> eventsProvider;
    @Inject
    private Provider<HAUtil> haUtilProvider;
    @Inject
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    @Inject
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    @Inject
    private WebSecurityManagerFactory webSecurityManagerFactory;
    private AppCNonceCacheMap appCnonceMap;
    private HAUtil haUtil;
    private CNonceCacheFactory cnonceCacheFactory;
    private static final String HA_CNONCE_BS_NAME = "HA-CNonceCache-Backingstore";
    private EventListener listener;
    private static WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static EjbSecurityPolicyProbeProvider ejbProbeProvider = new EjbSecurityPolicyProbeProvider();

    @Override
    public void postConstruct() {
        this.listener = new AppDeployEventListener();
        ((Events)this.eventsProvider.get()).register(this.listener);
    }

    protected void generateArtifacts(DeploymentContext context) throws DeploymentException {
        OpsParams params = context.getCommandParameters(OpsParams.class);
        if (params.origin.isArtifactsPresent()) {
            return;
        }
        String appName = params.name();
        try {
            Application app = (Application)context.getModuleMetaData(Application.class);
            Set webBundleDescriptors = app.getBundleDescriptors(WebBundleDescriptor.class);
            if (webBundleDescriptors == null) {
                return;
            }
            for (WebBundleDescriptor webBundleDescriptor : webBundleDescriptors) {
                this.loadPolicy(webBundleDescriptor, false);
            }
        }
        catch (Exception se) {
            throw new DeploymentException("Error in generating security policy for " + appName, (Throwable)se);
        }
    }

    protected void cleanArtifacts(DeploymentContext context) throws DeploymentException {
        CNonceCache cache;
        this.removePolicy(context);
        SecurityUtil.removeRoleMapper(context);
        OpsParams params = context.getCommandParameters(OpsParams.class);
        if (this.appCnonceMap != null && (cache = (CNonceCache)this.appCnonceMap.remove(params.name())) != null) {
            cache.destroy();
        }
    }

    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        DeployCommandParameters dparams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        Application app = (Application)context.getModuleMetaData(Application.class);
        this.handleCNonceCacheBSInit(app.getAppName(), app.getBundleDescriptors(WebBundleDescriptor.class), dparams.availabilityenabled);
        return new DummyApplication();
    }

    public void unload(DummyApplication container, DeploymentContext context) {
        this.cleanSecurityContext(context.getCommandParameters(OpsParams.class).name());
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public void loadPolicy(WebBundleDescriptor webDescriptor, boolean remove) throws DeploymentException {
        if (webDescriptor == null) {
            return;
        }
        try {
            JaccWebAuthorizationManager authorizationManager;
            if (remove && (authorizationManager = this.webSecurityManagerFactory.getManager(SecurityUtil.getContextID(webDescriptor), null, true)) != null) {
                authorizationManager.release();
            }
            this.webSecurityManagerFactory.createManager(webDescriptor, true, this.serverContext);
        }
        catch (Exception e) {
            _logger.log(Level.CONFIG, "[Web-Security] FATAL Exception. Unable to create WebSecurityManager: " + e.getMessage(), e);
            throw new DeploymentException("Error in generating security policy for " + webDescriptor.getModuleDescriptor().getModuleName(), (Throwable)e);
        }
    }

    private void commitWebPolicy(WebBundleDescriptor webBundleDescriptor) throws DeploymentException {
        try {
            if (webBundleDescriptor != null) {
                if (webBundleDescriptor.isPolicyModified()) {
                    this.loadPolicy(webBundleDescriptor, true);
                }
                String contextId = SecurityUtil.getContextID(webBundleDescriptor);
                websecurityProbeProvider.policyCreationStartedEvent(contextId);
                SecurityUtil.generatePolicyFile(contextId);
                websecurityProbeProvider.policyCreationEndedEvent(contextId);
                websecurityProbeProvider.policyCreationEvent(contextId);
            }
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + webBundleDescriptor.getModuleDescriptor().getModuleName();
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void commitEjbPolicies(Application app) throws DeploymentException {
        try {
            for (EjbBundleDescriptor ejbBD : app.getBundleDescriptors(EjbBundleDescriptor.class)) {
                String contextId = SecurityUtil.getContextID(ejbBD);
                ejbProbeProvider.policyCreationStartedEvent(contextId);
                SecurityUtil.generatePolicyFile(contextId);
                ejbProbeProvider.policyCreationEndedEvent(contextId);
                ejbProbeProvider.policyCreationEvent(contextId);
            }
        }
        catch (Exception se) {
            String msg = "Error in committing security policy for ejbs of " + app.getRegistrationName();
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void linkPolicies(Application app, Collection<WebBundleDescriptor> webBundleDescriptors) throws DeploymentException {
        try {
            String linkName = null;
            boolean lastInService = false;
            for (WebBundleDescriptor webBundleDescriptor : webBundleDescriptors) {
                String name = SecurityUtil.getContextID(webBundleDescriptor);
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
            linkName = null;
            Set ejbs = app.getBundleDescriptors(EjbBundleDescriptor.class);
            for (EjbBundleDescriptor ejbd : ejbs) {
                String name = SecurityUtil.getContextID(ejbd);
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
        }
        catch (IASSecurityException se) {
            throw new DeploymentException("Error in linking security policy for " + app.getRegistrationName(), (Throwable)se);
        }
    }

    private void removePolicy(DeploymentContext context) throws DeploymentException {
        OpsParams params = context.getCommandParameters(OpsParams.class);
        if (!params.origin.needsCleanArtifacts()) {
            return;
        }
        String appName = params.name();
        try {
            String[] webcontexts = this.webSecurityManagerFactory.getContextsForApp(appName, false);
            if (webcontexts != null) {
                for (String webcontext : webcontexts) {
                    if (webcontext == null) continue;
                    websecurityProbeProvider.policyDestructionStartedEvent(webcontext);
                    SecurityUtil.removePolicy(webcontext);
                    websecurityProbeProvider.policyDestructionEndedEvent(webcontext);
                    websecurityProbeProvider.policyDestructionEvent(webcontext);
                }
            }
        }
        catch (IASSecurityException ex) {
            String msg = "Error in removing security policy for " + appName;
            _logger.log(Level.WARNING, msg, ex);
            throw new DeploymentException(msg, (Throwable)ex);
        }
        this.cleanSecurityContext(appName);
    }

    private boolean cleanSecurityContext(String appName) {
        boolean cleanUpDone = false;
        List<JaccWebAuthorizationManager> managers = this.webSecurityManagerFactory.getManagersForApp(appName, false);
        if (managers == null) {
            return false;
        }
        for (JaccWebAuthorizationManager manager : managers) {
            try {
                websecurityProbeProvider.securityManagerDestructionStartedEvent(appName);
                manager.destroy();
                websecurityProbeProvider.securityManagerDestructionEndedEvent(appName);
                websecurityProbeProvider.securityManagerDestructionEvent(appName);
                cleanUpDone = true;
            }
            catch (Exception pce) {
                _logger.log(Level.WARNING, "Unable to destroy WebSecurityManager", pce);
            }
        }
        return cleanUpDone;
    }

    public static List<EventTypes> getDeploymentEvents() {
        ArrayList<EventTypes> events = new ArrayList<EventTypes>();
        events.add(Deployment.APPLICATION_PREPARED);
        return events;
    }

    private void handleCNonceCacheBSInit(String appName, Set<WebBundleDescriptor> webDesc, boolean isHA) {
        boolean hasDigest = false;
        for (WebBundleDescriptor webBD : webDesc) {
            LoginConfiguration lc = webBD.getLoginConfiguration();
            if (lc == null || !"DIGEST".equals(lc.getAuthenticationMethod())) continue;
            hasDigest = true;
            break;
        }
        if (!hasDigest) {
            return;
        }
        if (this.isHaEnabled() && isHA) {
            String clusterName = this.haUtil.getClusterName();
            String instanceName = this.haUtil.getInstanceName();
            if (this.cnonceCacheFactory != null) {
                CNonceCache cache = this.cnonceCacheFactory.createCNonceCache(appName, clusterName, instanceName, HA_CNONCE_BS_NAME);
                this.appCnonceMap.put(appName, cache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHaEnabled() {
        boolean haEnabled = false;
        SecurityDeployer securityDeployer = this;
        synchronized (securityDeployer) {
            if (this.haUtil == null) {
                this.haUtil = (HAUtil)this.haUtilProvider.get();
            }
        }
        if (this.haUtil != null && this.haUtil.isHAEnabled()) {
            haEnabled = true;
            securityDeployer = this;
            synchronized (securityDeployer) {
                if (this.appCnonceMap == null) {
                    this.appCnonceMap = (AppCNonceCacheMap)this.appCNonceCacheMapProvider.get();
                }
                if (this.cnonceCacheFactory == null) {
                    this.cnonceCacheFactory = (CNonceCacheFactory)this.cNonceCacheFactoryProvider.get();
                }
            }
        }
        return haEnabled;
    }

    private class AppDeployEventListener
    implements EventListener {
        private AppDeployEventListener() {
        }

        public void event(EventListener.Event event) {
            Application app = null;
            if (Deployment.MODULE_LOADED.equals((Object)event.type())) {
                ModuleInfo moduleInfo = (ModuleInfo)event.hook();
                if (moduleInfo instanceof ApplicationInfo) {
                    return;
                }
                WebBundleDescriptor webBD = (WebBundleDescriptor)moduleInfo.getMetaData("org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl");
                SecurityDeployer.this.loadPolicy(webBD, false);
            } else if (Deployment.APPLICATION_LOADED.equals((Object)event.type())) {
                RegisteredComponentInvocationHandler handler;
                ApplicationInfo appInfo = (ApplicationInfo)event.hook();
                app = (Application)appInfo.getMetaData(Application.class);
                if (app == null) {
                    return;
                }
                Set webBundleDescriptors = app.getBundleDescriptors(WebBundleDescriptor.class);
                SecurityDeployer.this.linkPolicies(app, webBundleDescriptors);
                SecurityDeployer.this.commitEjbPolicies(app);
                if (webBundleDescriptors != null && !webBundleDescriptors.isEmpty() && (handler = (RegisteredComponentInvocationHandler)SecurityDeployer.this.registeredComponentInvocationHandlerProvider.get()) != null) {
                    handler.register();
                }
            } else if (WebBundleDescriptor.AFTER_SERVLET_CONTEXT_INITIALIZED_EVENT.equals((Object)event.type())) {
                SecurityDeployer.this.commitWebPolicy((WebBundleDescriptor)event.hook());
            }
        }
    }
}

