/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth;

import jakarta.security.auth.message.MessagePolicy;

public class AuthPolicy {
    public static final int SOURCE_AUTH_NONE = 0;
    public static final int SOURCE_AUTH_SENDER = 1;
    public static final int SOURCE_AUTH_CONTENT = 2;
    public static final String SENDER = "sender";
    public static final String CONTENT = "content";
    public static final String BEFORE_CONTENT = "before-content";
    public static final String AFTER_CONTENT = "after-content";
    private int authenticateSource = 0;
    private boolean authenticateRecipient = false;
    private boolean recipientBeforeContent = false;

    private void setAuthenticationType(int sourceAuthType) {
        switch (sourceAuthType) {
            case 0: 
            case 1: 
            case 2: {
                this.authenticateSource = sourceAuthType;
                break;
            }
        }
    }

    public AuthPolicy() {
    }

    public AuthPolicy(int sourceAuthenticationType, boolean authenticateRecipient, boolean beforeContent) {
        this.setAuthenticationType(sourceAuthenticationType);
        this.authenticateRecipient = authenticateRecipient;
        this.recipientBeforeContent = beforeContent;
    }

    public AuthPolicy(MessagePolicy messagePolicy) {
        MessagePolicy.TargetPolicy[] targetPolicies;
        if (messagePolicy != null && (targetPolicies = messagePolicy.getTargetPolicies()) != null && targetPolicies.length > 0) {
            int contentInd = -1;
            int recipientInd = -1;
            for (int i = 0; i < targetPolicies.length; ++i) {
                MessagePolicy.ProtectionPolicy pp = targetPolicies[i].getProtectionPolicy();
                if ("#authenticateRecipient".equals(pp.getID())) {
                    recipientInd = i;
                    this.authenticateRecipient = true;
                    continue;
                }
                if ("#authenticateSender".equals(pp.getID())) {
                    contentInd = i;
                    this.setAuthenticationType(1);
                    continue;
                }
                if (!"#authenticateContent".equals(pp.getID())) continue;
                contentInd = i;
                this.setAuthenticationType(2);
            }
            if (this.authenticateRecipient && contentInd >= 0) {
                this.recipientBeforeContent = recipientInd < contentInd;
            }
        }
    }

    public void setSourceAuth(int sourceAuthenticationType) {
        this.setAuthenticationType(sourceAuthenticationType);
    }

    public void setContentAuth(boolean required) {
        if (required) {
            this.setSourceAuth(2);
        } else if (!this.isSenderAuthRequired()) {
            this.setSourceAuth(0);
        }
    }

    public void setSenderAuth(boolean required) {
        if (required) {
            this.setSourceAuth(1);
        } else if (!this.isContentAuthRequired()) {
            this.setSourceAuth(0);
        }
    }

    public void setRecipientAuth(boolean required, boolean beforeContent) {
        this.authenticateRecipient = required;
        this.recipientBeforeContent = beforeContent;
    }

    public int getSourceAuth() {
        return this.authenticateSource;
    }

    public boolean authRequired() {
        return this.isSourceAuthRequired() || this.isRecipientAuthRequired();
    }

    public boolean isSourceAuthRequired() {
        return this.authenticateSource != 0;
    }

    public boolean isSenderAuthRequired() {
        return this.isSourceAuthRequired() ? this.getSourceAuth() == 1 : false;
    }

    public boolean isContentAuthRequired() {
        return this.isSourceAuthRequired() ? this.getSourceAuth() == 2 : false;
    }

    public boolean isRecipientAuthRequired() {
        return this.authenticateRecipient;
    }

    public boolean isRecipientAuthBeforeContent() {
        return this.recipientBeforeContent;
    }

    public boolean isRecipientAuthBeforeContent(boolean orderForValidation) {
        return orderForValidation ? !this.recipientBeforeContent : this.recipientBeforeContent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.authenticateSource) {
            case 0: {
                sb.append("source-auth-type = SOURCE_AUTH_NONE");
                break;
            }
            case 1: {
                sb.append("source-auth-type = SOURCE_AUTH_SENDER");
                break;
            }
            case 2: {
                sb.append("source-auth-type = SOURCE_AUTH_CONTENT");
                break;
            }
        }
        if (this.authenticateRecipient) {
            sb.append("\n\tauthenticate-recipient=true\n\tbeforeContent=" + this.recipientBeforeContent);
        } else {
            sb.append("\n\tauthenticate-recipient=false");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthPolicy)) {
            return false;
        }
        AuthPolicy that = (AuthPolicy)o;
        return this.authenticateSource == that.authenticateSource && this.authenticateRecipient == that.authenticateRecipient && this.recipientBeforeContent == that.recipientBeforeContent;
    }

    public int hashCode() {
        return this.authenticateSource + (this.authenticateRecipient ? 5 : 0) + (this.recipientBeforeContent ? 10 : 0);
    }
}

