/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.admin.mbeanserver.JMXStartupService;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.BootAMXMBean;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public final class BootAMX
implements BootAMXMBean {
    private static final Logger JMX_LOGGER = Util.JMX_LOGGER;
    @Inject
    private ServiceLocator mHabitat;
    private final MBeanServer mMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName mObjectName = BootAMX.getBootAMXMBeanObjectName();
    private ObjectName mDomainRootObjectName = null;
    @LogMessageInfo(message="Error while shutting down AMX", level="WARNING")
    static final String errorDuringShutdown = "NCLS-JMX--00008";

    public BootAMX() {
        if (this.mMBeanServer.isRegistered(this.mObjectName)) {
            throw new IllegalStateException("AMX Booter MBean is already registered: " + this.mObjectName);
        }
    }

    @PostConstruct
    public void postConstuct() {
        try {
            StandardMBean mbean = new StandardMBean(this, BootAMXMBean.class);
            if (!this.mMBeanServer.registerMBean(mbean, this.mObjectName).getObjectName().equals(this.mObjectName)) {
                throw new IllegalStateException();
            }
        }
        catch (JMException e) {
            JMX_LOGGER.log(Level.SEVERE, null, e);
            throw new IllegalStateException(e);
        }
    }

    public static ObjectName getBootAMXMBeanObjectName() {
        return AMXGlassfish.DEFAULT.getBootAMXMBeanObjectName();
    }

    AMXStartupServiceMBean getLoader() {
        try {
            return (AMXStartupServiceMBean)this.mHabitat.getService(AMXStartupServiceMBean.class, new Annotation[0]);
        }
        catch (Throwable t) {
            JMX_LOGGER.log(Level.SEVERE, null, t);
            throw new RuntimeException(t);
        }
    }

    public synchronized ObjectName bootAMX() {
        if (this.mDomainRootObjectName == null) {
            this.getLoader();
            ObjectName startupON = AMXStartupServiceMBean.OBJECT_NAME;
            if (!this.mMBeanServer.isRegistered(startupON)) {
                JMX_LOGGER.log(Level.FINEST, "Booter.bootAMX(): AMX MBean not yet available: {0}", startupON);
                throw new IllegalStateException("AMX MBean not yet available: " + startupON);
            }
            try {
                JMX_LOGGER.log(Level.FINEST, "Booter.bootAMX: invoking loadAMXMBeans() on {0}", startupON);
                this.mDomainRootObjectName = (ObjectName)this.mMBeanServer.invoke(startupON, "loadAMXMBeans", null, null);
                JMX_LOGGER.log(Level.FINEST, "Booter.bootAMX: domainRoot = {0}", this.mDomainRootObjectName);
            }
            catch (JMException e) {
                JMX_LOGGER.log(Level.SEVERE, null, e);
                throw new RuntimeException(e);
            }
        }
        return this.mDomainRootObjectName;
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        return JMXStartupService.getJMXServiceURLs(this.mMBeanServer);
    }

    @PreDestroy
    public void shutdown() {
        try {
            if (this.mMBeanServer.isRegistered(BootAMX.getBootAMXMBeanObjectName())) {
                this.mMBeanServer.unregisterMBean(BootAMX.getBootAMXMBeanObjectName());
            }
        }
        catch (Exception e) {
            Util.getLogger().log(Level.WARNING, errorDuringShutdown, e);
        }
    }
}

