/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.listener;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ManagedConnection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalTxConnectionEventListener
extends ConnectionEventListener {
    private static final Logger LOGGER = LogDomains.getLogger(LocalTxConnectionEventListener.class, (String)"javax.enterprise.resource.resourceadapter");
    private final PoolManager poolMgr;
    private final Map<Object, ResourceHandle> associatedHandles;
    private final ResourceHandle resource;

    public LocalTxConnectionEventListener(ResourceHandle resource) {
        this.resource = resource;
        this.associatedHandles = new IdentityHashMap<Object, ResourceHandle>(10);
        this.poolMgr = ConnectorRuntime.getRuntime().getPoolManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        LocalTxConnectionEventListener localTxConnectionEventListener = this;
        synchronized (localTxConnectionEventListener) {
            ResourceHandle handle = this.getResourceHandle(connectionHandle);
            if (handle != null) {
                this.poolMgr.resourceClosed(handle);
            }
        }
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent evt) {
        this.resource.setConnectionErrorOccurred();
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
        this.poolMgr.resourceErrorOccurred(this.resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void badConnectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        LocalTxConnectionEventListener localTxConnectionEventListener = this;
        synchronized (localTxConnectionEventListener) {
            ResourceHandle handle = this.getResourceHandle(connectionHandle);
            if (handle != null) {
                this.poolMgr.badResourceClosed(handle);
                ManagedConnection mc = (ManagedConnection)evt.getSource();
                mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
            }
        }
    }

    public void localTransactionStarted(ConnectionEvent evt) {
    }

    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    public void localTransactionRolledback(ConnectionEvent evt) {
    }

    public synchronized void associateHandle(Object c, ResourceHandle h) {
        this.associatedHandles.put(c, h);
    }

    public synchronized ResourceHandle removeAssociation(Object c) {
        return this.associatedHandles.remove(c);
    }

    public synchronized void resetAssociations() throws ResourceException {
        for (Map.Entry<Object, ResourceHandle> userHandleEntry : this.associatedHandles.entrySet()) {
            Object connectionHandle = userHandleEntry.getKey();
            ResourceHandle associatedHandle = userHandleEntry.getValue();
            ManagedConnection associatedConnection = (ManagedConnection)associatedHandle.getResource();
            associatedConnection.associateConnection(connectionHandle);
            LOGGER.log(Level.FINE, "connection_sharing_reset_association", connectionHandle);
        }
        this.associatedHandles.clear();
    }

    private ResourceHandle getResourceHandle(Object connectionHandle) {
        ResourceHandle handle = this.associatedHandles.get(connectionHandle);
        if (handle != null) {
            return handle;
        }
        return this.resource;
    }
}

