/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.npn;

import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;
import org.glassfish.grizzly.npn.AlpnServerNegotiator;
import org.glassfish.grizzly.npn.ClientSideNegotiator;
import org.glassfish.grizzly.npn.ServerSideNegotiator;

public class NegotiationSupport {
    private static final ConcurrentHashMap<String, ServerSideNegotiator> serverSideNegotiators = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ClientSideNegotiator> clientSideNegotiators = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AlpnServerNegotiator> alpnServerNegotiators = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AlpnClientNegotiator> alpnClientNegotiators = new ConcurrentHashMap();

    public static void addNegotiator(SSLEngine engine, ServerSideNegotiator serverSideNegotiator) {
        serverSideNegotiators.putIfAbsent(NegotiationSupport.generateKey(engine), serverSideNegotiator);
    }

    public static void addNegotiator(SSLEngine engine, ClientSideNegotiator clientSideNegotiator) {
        clientSideNegotiators.putIfAbsent(NegotiationSupport.generateKey(engine), clientSideNegotiator);
    }

    public static void addNegotiator(SSLEngine engine, AlpnServerNegotiator serverSideNegotiator) {
        alpnServerNegotiators.putIfAbsent(NegotiationSupport.generateKey(engine), serverSideNegotiator);
    }

    public static void addNegotiator(SSLEngine engine, AlpnClientNegotiator clientSideNegotiator) {
        alpnClientNegotiators.putIfAbsent(NegotiationSupport.generateKey(engine), clientSideNegotiator);
    }

    public static ClientSideNegotiator removeClientNegotiator(SSLEngine engine) {
        return clientSideNegotiators.remove(NegotiationSupport.generateKey(engine));
    }

    public static AlpnClientNegotiator removeAlpnClientNegotiator(SSLEngine engine) {
        return alpnClientNegotiators.remove(NegotiationSupport.generateKey(engine));
    }

    public static ServerSideNegotiator removeServerNegotiator(SSLEngine engine) {
        return serverSideNegotiators.remove(NegotiationSupport.generateKey(engine));
    }

    public static AlpnServerNegotiator removeAlpnServerNegotiator(SSLEngine engine) {
        return alpnServerNegotiators.remove(NegotiationSupport.generateKey(engine));
    }

    public static ServerSideNegotiator getServerSideNegotiator(SSLEngine engine) {
        return serverSideNegotiators.get(NegotiationSupport.generateKey(engine));
    }

    public static ClientSideNegotiator getClientSideNegotiator(SSLEngine engine) {
        return clientSideNegotiators.get(NegotiationSupport.generateKey(engine));
    }

    public static AlpnServerNegotiator getAlpnServerNegotiator(SSLEngine engine) {
        return alpnServerNegotiators.get(NegotiationSupport.generateKey(engine));
    }

    public static AlpnClientNegotiator getAlpnClientNegotiator(SSLEngine engine) {
        return alpnClientNegotiators.get(NegotiationSupport.generateKey(engine));
    }

    private static String generateKey(SSLEngine engine) {
        if (engine != null) {
            return engine.getClass().getName() + "@" + Integer.toHexString(engine.hashCode());
        }
        return null;
    }
}

