/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.MessageBytes;

public class FormAuthenticator
extends AuthenticatorBase {
    private static final String PERMITTED_FORM_BASED_AUTH_HTTP_METHODS_PROPERTY = "fish.payara.permittedFormBasedAuthHttpMethods";
    protected static final String info = "org.apache.catalina.authenticator.FormAuthenticator/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        char[] password;
        boolean loginAction;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        Session session = null;
        String contextPath = hreq.getContextPath();
        Object requestURI = request.getDecodedRequestURI();
        boolean bl = loginAction = ((String)requestURI).startsWith(contextPath) && ((String)requestURI).endsWith("/j_security_check");
        if (loginAction && !FormAuthenticator.isPermittedHttpMethod(hreq.getMethod())) {
            hres.sendError(403, rb.getString("AS-WEB-CORE-00313"));
            return false;
        }
        Principal principal = hreq.getUserPrincipal();
        if (principal != null && !loginAction) {
            String ssoId;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Already authenticated '" + principal.getName() + "'");
            }
            if ((ssoId = (String)request.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.getSession(request, true);
            }
            return true;
        }
        if (!this.cache && !loginAction) {
            session = this.getSession(request, true);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Checking for reauthenticate in session " + session);
            }
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            char[] password2 = (char[])session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password2 != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reauthenticating username '" + username + "'");
                }
                if ((principal = this.context.getRealm().authenticate(username, password2)) != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
                    if (!this.matchRequest(request)) {
                        this.register(request, response, principal, "FORM", username, password2);
                        return true;
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request)) {
            session = this.getSession(request, true);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Restore request from session '" + session.getIdInternal() + "'");
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (char[])session.getNote("org.apache.catalina.session.PASSWORD"));
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.associate(ssoId, this.getSsoVersion(request), session);
            }
            if (this.restoreRequest(request, session)) {
                log.fine("Proceed to restored request");
                return true;
            }
            log.fine("Restore of original request failed");
            hres.sendError(400);
            return false;
        }
        CharChunk uriCC = MessageBytes.newInstance().getCharChunk();
        uriCC.setLimit(-1);
        response.setContext(request.getContext());
        if (!loginAction) {
            session = this.getSession(request, true);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Save request in session '" + session.getIdInternal() + "'");
            }
            this.saveRequest(request, session);
            this.forwardToLoginPage(request, response, config);
            return false;
        }
        Realm realm = this.context.getRealm();
        String username = hreq.getParameter("j_username");
        String pwd = hreq.getParameter("j_password");
        char[] cArray = password = pwd != null ? pwd.toCharArray() : null;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Authenticating username '" + username + "'");
        }
        if ((principal = realm.authenticate(username, password)) == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Authentication of '" + username + "' was successful");
        }
        if (session == null) {
            session = this.getSession(request, true);
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        if (!this.cache) {
            session.setNote("org.apache.catalina.session.USERNAME", username);
            session.setNote("org.apache.catalina.session.PASSWORD", password);
        }
        if ((requestURI = this.savedRequestURL(session)) == null) {
            requestURI = hreq.getContextPath() + "/";
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (char[])session.getNote("org.apache.catalina.session.PASSWORD"));
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.associate(ssoId, this.getSsoVersion(request), session);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Redirecting to original '" + (String)requestURI + "'");
        }
        hres.sendRedirect(hres.encodeRedirectURL((String)requestURI));
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "FORM";
    }

    protected boolean matchRequest(HttpRequest request) {
        Session session = this.getSession(request, false);
        if (session == null) {
            return false;
        }
        SavedRequest savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (savedRequest == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI == null) {
            return false;
        }
        return requestURI.equals(savedRequest.getRequestURI());
    }

    protected boolean restoreRequest(HttpRequest request, Session session) throws IOException {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (saved == null) {
            return false;
        }
        byte[] buffer = new byte[4096];
        InputStream is = request.getStream();
        while (is.read(buffer) >= 0) {
        }
        request.clearCookies();
        Iterator<Cookie> cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie(cookies.next());
        }
        String method = saved.getMethod();
        boolean cachable = "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
        request.clearHeaders();
        Iterator<String> names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = names.next();
            if ("If-Modified-Since".equalsIgnoreCase(name) || cachable && "If-None-Match".equalsIgnoreCase(name)) continue;
            Iterator<String> values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                request.addHeader(name, values.next());
            }
        }
        request.setContentLength(saved.getContentLenght());
        request.clearLocales();
        Iterator<Locale> locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale(locales.next());
        }
        request.clearParameters();
        ByteChunk body = saved.getBody();
        if (body != null) {
            byte[] tempData = body.getBytes();
            byte[] data = new byte[body.getLength()];
            System.arraycopy(tempData, body.getStart(), data, 0, data.length);
            request.replayPayload(data);
            String savedContentType = saved.getContentType();
            if (savedContentType == null && "POST".equalsIgnoreCase(method)) {
                savedContentType = "application/x-www-form-urlencoded";
            }
            request.setContentType(savedContentType);
        }
        request.setMethod(method);
        request.setQueryString(saved.getQueryString());
        return true;
    }

    protected void forwardToLoginPage(HttpRequest request, HttpResponse response, LoginConfig config) {
        if (this.isChangeSessionIdOnAuthentication() && this.getSession(request, false) != null) {
            request.changeSessionId();
        }
        ServletContext servletContext = this.context.getServletContext();
        try {
            SecurityConstraint[] secConstraints;
            Realm realm;
            String loginPage = config.getLoginPage();
            if (!request.getRequest().isSecure() && (realm = this.context.getRealm()) != null && (secConstraints = realm.findSecurityConstraints(loginPage, "GET", this.context)) != null && !realm.hasUserDataPermission(request, response, secConstraints, loginPage, "GET")) {
                return;
            }
            servletContext.getRequestDispatcher(loginPage).forward(request.getRequest(), response.getResponse());
            response.finishResponse();
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "AS-WEB-CORE-00004", t);
        }
    }

    protected void forwardToErrorPage(HttpRequest request, HttpResponse response, LoginConfig config) {
        ServletContext servletContext = this.context.getServletContext();
        try {
            SecurityConstraint[] secConstraints;
            Realm realm;
            String errorPage = config.getErrorPage();
            if (!request.getRequest().isSecure() && (realm = this.context.getRealm()) != null && (secConstraints = realm.findSecurityConstraints(errorPage, "GET", this.context)) != null && !realm.hasUserDataPermission(request, response, secConstraints, errorPage, "GET")) {
                return;
            }
            servletContext.getRequestDispatcher(errorPage).forward(request.getRequest(), response.getResponse());
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "AS-WEB-CORE-00004", t);
        }
    }

    protected void saveRequest(HttpRequest request, Session session) throws IOException {
        int bytesRead;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        SavedRequest savedRequest = new SavedRequest();
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                savedRequest.addCookie(cookie);
            }
        }
        Enumeration<String> names = httpServletRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = httpServletRequest.getHeaders(name);
            while (values.hasMoreElements()) {
                savedRequest.addHeader(name, values.nextElement());
            }
        }
        savedRequest.setContentLength(httpServletRequest.getContentLength());
        Enumeration<Locale> locales = httpServletRequest.getLocales();
        while (locales.hasMoreElements()) {
            savedRequest.addLocale(locales.nextElement());
        }
        ((HttpResponse)request.getResponse()).sendAcknowledgement();
        ByteChunk body = new ByteChunk();
        body.setLimit(request.getConnector().getMaxSavePostSize());
        byte[] buffer = new byte[4096];
        InputStream is = request.getStream();
        while ((bytesRead = is.read(buffer)) >= 0) {
            body.append(buffer, 0, bytesRead);
        }
        if (body.getLength() > 0) {
            savedRequest.setContentType(httpServletRequest.getContentType());
            savedRequest.setBody(body);
        }
        savedRequest.setMethod(httpServletRequest.getMethod());
        savedRequest.setQueryString(httpServletRequest.getQueryString());
        savedRequest.setRequestURI(httpServletRequest.getRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", savedRequest);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuilder savedRequestURL = new StringBuilder(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            savedRequestURL.append('?');
            savedRequestURL.append(saved.getQueryString());
        }
        while (savedRequestURL.length() > 1 && savedRequestURL.charAt(1) == '/') {
            savedRequestURL.deleteCharAt(0);
        }
        return savedRequestURL.toString();
    }

    private long getSsoVersion(HttpRequest request) {
        long ssoVersion = 0L;
        Long ssoVersionObj = (Long)request.getNote("org.apache.catalina.request.SSOVersion");
        if (ssoVersionObj != null) {
            ssoVersion = ssoVersionObj;
        }
        return ssoVersion;
    }

    private static boolean isPermittedHttpMethod(String usedMethod) {
        String permittedHttpMethods = System.getProperty(PERMITTED_FORM_BASED_AUTH_HTTP_METHODS_PROPERTY);
        if (permittedHttpMethods == null) {
            return true;
        }
        for (String validMethod : permittedHttpMethods.split(",")) {
            if (!validMethod.equalsIgnoreCase(usedMethod)) continue;
            return true;
        }
        return false;
    }
}

