/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import jakarta.servlet.ServletContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StoreBase;

public final class FileStore
extends StoreBase {
    private static final Logger LOGGER = LogFacade.getLogger();
    private static final ResourceBundle RESOURCE_BUNDLE = LOGGER.getResourceBundle();
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String path) {
        String oldDirectory = this.directory;
        this.directory = path;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return threadName;
    }

    @Override
    public String getStoreName() {
        return storeName;
    }

    @Override
    public int getSize() throws IOException {
        File file = this.directory();
        if (file == null) {
            return 0;
        }
        String[] files = file.list();
        int keycount = 0;
        for (String file1 : files) {
            if (!file1.endsWith(FILE_EXT)) continue;
            ++keycount;
        }
        return keycount;
    }

    @Override
    public void clear() throws IOException {
        String[] keys;
        for (String key : keys = this.keys()) {
            this.remove(key);
        }
    }

    @Override
    public String[] keys() throws IOException {
        File file = this.directory();
        if (file == null) {
            return new String[0];
        }
        String[] files = file.list();
        ArrayList<String> list = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (String file1 : files) {
            if (!file1.endsWith(FILE_EXT)) continue;
            list.add(file1.substring(0, file1.length() - n));
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Session load(String id) throws ClassNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ObjectInputStream createObjectInputStream(Container container, BufferedInputStream bis) throws IOException {
        if (container != null) {
            return ((StandardContext)container).createObjectInputStream(bis);
        }
        return new ObjectInputStream(bis);
    }

    @Override
    public void remove(String id) throws IOException {
        File file = this.file(id);
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00339"), id, file.getAbsolutePath());
            this.log(msg);
        }
        this.sessions.remove(id);
        if (!file.delete() && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cannot delete file: {0}", file);
        }
    }

    @Override
    public void save(Session session) throws IOException {
        File file = this.file(session.getIdInternal());
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00340"), session.getIdInternal(), file.getAbsolutePath());
            this.log(msg);
        }
        ObjectOutputStream oos = null;
        try (FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            Container container = this.manager.getContainer();
            oos = container != null ? ((StandardContext)container).createObjectOutputStream(bos) : new ObjectOutputStream(bos);
            oos.writeObject(session);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File directory() throws IOException {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            Container container = this.manager.getContainer();
            if (container instanceof Context) {
                ServletContext servletContext = ((Context)container).getServletContext();
                File work = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
                file = new File(work, this.directory);
            } else {
                throw new IllegalArgumentException("Parent Container is not a Context");
            }
        }
        if (!file.exists() || !file.isDirectory()) {
            String msg;
            if (!file.delete() && file.exists()) {
                msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00341"), file);
                throw new IOException(msg);
            }
            if (!file.mkdirs() && !file.isDirectory()) {
                msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00342"), file);
                throw new IOException(msg);
            }
        }
        this.directoryFile = file;
        return file;
    }

    private File file(String id) throws IOException {
        if (this.directory == null) {
            return null;
        }
        String filename = id + FILE_EXT;
        File file = new File(this.directory(), filename);
        return file;
    }
}

