/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Host;
import org.apache.catalina.LogFacade;

public class ExpandWar {
    private static final Logger LOGGER = LogFacade.getLogger();
    private static final ResourceBundle RESOURCE_BUNDLE = LOGGER.getResourceBundle();

    public static String expand(Host host, URL war) throws IOException {
        int slash;
        int period;
        String pathname = war.toString().replace('\\', '/');
        if (pathname.endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        return ExpandWar.expand(host, war, pathname);
    }

    public static String expand(Host host, URL war, String pathname) throws IOException {
        File appBase = new File(host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!appBase.exists() || !appBase.isDirectory()) {
            String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00444"), appBase.getAbsolutePath());
            throw new IOException(msg);
        }
        File docBase = new File(appBase, pathname);
        if (docBase.exists()) {
            return docBase.getAbsolutePath();
        }
        if (!docBase.mkdir()) {
            String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00445"), docBase);
            throw new IOException(msg);
        }
        Object canonicalDocBasePrefix = docBase.getCanonicalPath();
        if (!((String)canonicalDocBasePrefix).endsWith(File.separator)) {
            canonicalDocBasePrefix = (String)canonicalDocBasePrefix + File.separator;
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input = null;
        boolean success = false;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File expandedFile = new File(docBase, name);
                if (!expandedFile.getCanonicalPath().startsWith((String)canonicalDocBasePrefix)) {
                    String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00446"), war, name);
                    throw new IllegalArgumentException(msg);
                }
                int last = name.lastIndexOf(47);
                if (last >= 0 && !(parent = new File(docBase, name.substring(0, last))).mkdirs() && !parent.isDirectory()) {
                    String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00445"), parent);
                    throw new IOException(msg);
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                ExpandWar.expand(input, expandedFile);
                long lastModified = jarEntry.getTime();
                if (lastModified != -1L && lastModified != 0L && !expandedFile.setLastModified(lastModified) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "AS-WEB-CORE-00447", expandedFile.getAbsolutePath());
                }
                input.close();
                input = null;
            }
            success = true;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (!success) {
                ExpandWar.deleteDir(docBase);
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
                input = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {}
                jarFile = null;
            }
        }
        return docBase.getAbsolutePath();
    }

    public static void validate(Host host, URL war, String pathname) throws IOException {
        File docBase;
        Object canonicalDocBasePrefix;
        File appBase = new File(host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!((String)(canonicalDocBasePrefix = (docBase = new File(appBase, pathname)).getCanonicalPath())).endsWith(File.separator)) {
            canonicalDocBasePrefix = (String)canonicalDocBasePrefix + File.separator;
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        try (JarFile jarFile = juc.getJarFile();){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File expandedFile = new File(docBase, name);
                if (expandedFile.getCanonicalPath().startsWith((String)canonicalDocBasePrefix)) continue;
                String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00446"), war, name);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public static boolean copy(File src, File dest) {
        String[] files;
        boolean result = true;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ExpandWar.copy(fileSrc, fileDest);
                continue;
            }
            try (FileChannel ic = new FileInputStream(fileSrc).getChannel();
                 FileChannel oc = new FileOutputStream(fileDest).getChannel();){
                ic.transferTo(0L, ic.size(), oc);
                continue;
            }
            catch (IOException e) {
                String msg = MessageFormat.format(RESOURCE_BUNDLE.getString("AS-WEB-CORE-00448"), fileSrc, fileDest);
                LOGGER.log(Level.SEVERE, msg, e);
                result = false;
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        return ExpandWar.delete(dir, true);
    }

    public static boolean delete(File dir, boolean logFailure) {
        boolean result = dir.isDirectory() ? ExpandWar.deleteDir(dir, logFailure) : (dir.exists() ? dir.delete() : true);
        if (logFailure && !result) {
            LOGGER.log(Level.SEVERE, "AS-WEB-CORE-00449", dir.getAbsolutePath());
        }
        return result;
    }

    public static boolean deleteDir(File dir) {
        return ExpandWar.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean logFailure) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (String file1 : files) {
            File file = new File(dir, file1);
            if (file.isDirectory()) {
                ExpandWar.deleteDir(file, logFailure);
                continue;
            }
            if (file.delete() || !logFailure) continue;
            LOGGER.log(Level.SEVERE, "AS-WEB-CORE-00449", file.getAbsolutePath());
        }
        boolean result = dir.exists() ? dir.delete() : true;
        if (logFailure && !result) {
            LOGGER.log(Level.SEVERE, "AS-WEB-CORE-00449", dir.getAbsolutePath());
        }
        return result;
    }

    protected static void expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        ExpandWar.expand(input, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(InputStream input, File file) throws IOException {
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

