/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.ArgumentTokenizer;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.ExternalTerminal;
import org.jvnet.hk2.annotations.Service;

@Service(name="multimode")
@PerLookup
public class MultimodeCommand
extends CLICommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private CLIContainer container;
    @Param(optional=true, shortName="f")
    private File file;
    @Param(name="printprompt", optional=true)
    private Boolean printPromptOpt;
    private boolean printPrompt;
    @Param(optional=true)
    private String encoding;
    private boolean echo;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MultimodeCommand.class);

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.printPrompt = this.printPromptOpt != null ? this.printPromptOpt.booleanValue() : this.programOpts.isInteractive();
        this.echo = this.programOpts.isEcho();
    }

    @Override
    protected Collection<CommandModel.ParamModel> usageOptions() {
        Collection opts = this.commandModel.getParameters();
        LinkedHashSet<CommandModel.ParamModel> uopts = new LinkedHashSet<CommandModel.ParamModel>();
        CommandModelData.ParamModelData p = new CommandModelData.ParamModelData("printprompt", Boolean.TYPE, true, Boolean.toString(this.programOpts.isInteractive()));
        for (CommandModel.ParamModel pm : opts) {
            if (pm.getName().equals("printprompt")) {
                uopts.add((CommandModel.ParamModel)p);
                continue;
            }
            uopts.add(pm);
        }
        return uopts;
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        LineReader reader = null;
        this.programOpts.setEcho(this.echo);
        try {
            if (this.file == null) {
                System.out.println(strings.get("multimodeIntro"));
                Completer completer = this.getAllCommandsCompleter();
                Terminal asadminTerminal = TerminalBuilder.builder().name("asadmin").system(true).encoding(this.encoding != null ? Charset.forName(this.encoding) : Charset.defaultCharset()).build();
                reader = this.newLineReaderBuilder().terminal(asadminTerminal).completer(completer).build();
                reader.unsetOpt(LineReader.Option.INSERT_TAB);
            } else {
                this.printPrompt = false;
                if (!this.file.canRead()) {
                    throw new CommandException("File: " + this.file + " can not be read");
                }
                OutputStream out = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                    }
                };
                ExternalTerminal asadminTerminal = new ExternalTerminal("asadmin", "", (InputStream)new FileInputStream(this.file), out, this.encoding != null ? Charset.forName(this.encoding) : Charset.defaultCharset());
                reader = this.newLineReaderBuilder().terminal((Terminal)asadminTerminal).build();
            }
            int out = this.executeCommands(reader);
            return out;
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                if (this.file != null && reader != null && reader.getTerminal() != null) {
                    reader.getTerminal().close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void atomicReplace(ServiceLocator locator, ProgramOptions options) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter((Filter)BuilderHelper.createContractFilter((String)ProgramOptions.class.getName()));
        AbstractActiveDescriptor desc = BuilderHelper.createConstantDescriptor((Object)options, null, (Type[])new Type[]{ProgramOptions.class});
        config.addActiveDescriptor((ActiveDescriptor)desc);
        config.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommands(LineReader reader) throws IOException {
        String line = null;
        int rc = 0;
        this.programOpts.toEnvironment(this.env);
        String prompt = this.programOpts.getCommandName() + "> ";
        while (true) {
            String command;
            String[] args;
            block26: {
                try {
                    line = this.printPrompt ? reader.readLine(prompt) : reader.readLine();
                    if (line == null) {
                        if (!this.printPrompt) break;
                        System.out.println();
                    }
                    break block26;
                }
                catch (EndOfFileException | UserInterruptException e) {}
                break;
            }
            if (line.trim().startsWith("#")) continue;
            try {
                args = this.getArgs(line);
            }
            catch (ArgumentTokenizer.ArgumentException ex) {
                logger.info(ex.getMessage());
                continue;
            }
            if (args.length == 0 || (command = args[0]).length() == 0) continue;
            if (command.equals("exit") || command.equals("quit")) break;
            CLICommand cmd = null;
            ProgramOptions po = null;
            try {
                po = new ProgramOptions(this.env);
                po.setClassPath(this.programOpts.getClassPath());
                po.setClassName(this.programOpts.getClassName());
                po.setCommandName(this.programOpts.getCommandName());
                MultimodeCommand.atomicReplace(this.habitat, po);
                cmd = CLICommand.getCommand(this.habitat, command);
                rc = this.file == null ? cmd.execute(reader.getTerminal(), args) : cmd.execute(args);
            }
            catch (CommandValidationException cve) {
                logger.severe(cve.getMessage());
                if (cmd != null) {
                    logger.severe(cmd.getUsage());
                }
                rc = 1;
            }
            catch (InvalidCommandException ice) {
                logger.severe(ice.getMessage());
                try {
                    if (po != null) {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(this.container, po, this.env), strings.get("ClosestMatchedLocalAndRemoteCommands"), logger);
                    }
                }
                catch (InvalidCommandException invalidCommandException) {
                    // empty catch block
                }
                rc = 1;
            }
            catch (CommandException ce) {
                if (ce.getCause() instanceof ConnectException) {
                    logger.severe(ce.getMessage());
                    try {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(this.container), strings.get("ClosestMatchedLocalCommands"), logger);
                    }
                    catch (InvalidCommandException e) {
                        logger.info(strings.get("InvalidRemoteCommand", new Object[]{command}));
                    }
                } else {
                    logger.severe(ce.getMessage());
                }
                rc = 1;
            }
            finally {
                MultimodeCommand.atomicReplace(this.habitat, this.programOpts);
            }
            switch (rc) {
                case 0: {
                    if (this.programOpts.isTerse()) break;
                    logger.log(Level.FINE, strings.get("CommandSuccessful", new Object[]{command}));
                    break;
                }
                default: {
                    logger.log(Level.FINE, strings.get("CommandUnSuccessful", new Object[]{command}));
                }
            }
            CLIUtil.writeCommandToDebugLog(this.programOpts.getCommandName() + "[multimode]", this.env, args, rc);
        }
        return rc;
    }

    private String[] getArgs(String line) throws ArgumentTokenizer.ArgumentException {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentTokenizer t = new ArgumentTokenizer(line);
        while (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        return args.toArray(new String[args.size()]);
    }

    private Completer getAllCommandsCompleter() {
        return new StringsCompleter(CLIUtil.getAllCommands(this.container, this.programOpts, this.env));
    }
}

