/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;

public class Parser {
    private ParameterMap optionsMap = new ParameterMap();
    private Set<String> invalidOptions = new HashSet<String>();
    private List<String> operands = new ArrayList<String>();
    private Collection<CommandModel.ParamModel> options;
    private boolean ignoreUnknown;
    private static final LocalStringsImpl strings = new LocalStringsImpl(Parser.class);

    public Parser(String[] args, int start, Collection<CommandModel.ParamModel> options, boolean ignoreUnknown) throws CommandValidationException {
        this.options = options;
        this.ignoreUnknown = ignoreUnknown;
        this.parseCommandLine(args, start);
    }

    private void parseCommandLine(String[] argv, int start) throws CommandValidationException {
        block0: for (int si = start; si < argv.length; ++si) {
            String arg = argv[si];
            if (arg.equals("--")) {
                if (!this.ignoreUnknown) {
                    ++si;
                }
                while (si < argv.length) {
                    this.operands.add(argv[si++]);
                }
                break;
            }
            if (!arg.startsWith("-") || arg.length() <= 1) {
                this.operands.add(StringUtils.removeEnclosingQuotes((String)arg));
                if (this.ignoreUnknown) continue;
                ++si;
                while (si < argv.length) {
                    this.operands.add(argv[si++]);
                }
                break;
            }
            CommandModel.ParamModel opt = null;
            String name = null;
            String value = null;
            if (arg.charAt(1) == '-') {
                int ne;
                int ns = 2;
                boolean sawno = false;
                if (arg.startsWith("--no-")) {
                    sawno = true;
                    value = "false";
                    ns = 5;
                }
                if ((ne = arg.indexOf(61)) < 0) {
                    name = arg.substring(ns);
                } else {
                    if (value != null) {
                        throw new CommandValidationException(strings.get("parser.noValueAllowed", new Object[]{arg}));
                    }
                    name = arg.substring(ns, ne);
                    value = arg.substring(ne + 1);
                }
                opt = this.lookupLongOption(name);
                if (sawno && Parser.optionRequiresOperand(opt)) {
                    throw new CommandValidationException(strings.get("parser.illegalNo", new Object[]{opt.getName()}));
                }
            } else if (arg.length() <= 2) {
                opt = this.lookupShortOption(arg.charAt(1));
                name = arg.substring(1);
            } else if (arg.charAt(2) == '=') {
                opt = this.lookupShortOption(arg.charAt(1));
                value = arg.substring(3);
            } else {
                for (int i = 1; i < arg.length(); ++i) {
                    opt = this.lookupShortOption(arg.charAt(i));
                    if (opt == null) {
                        if (!this.ignoreUnknown) {
                            this.invalidOptions.add(arg);
                        }
                        this.operands.add(arg);
                        continue block0;
                    }
                    if (opt.getType() != Boolean.class && opt.getType() != Boolean.TYPE) {
                        if (!this.ignoreUnknown) {
                            throw new CommandValidationException(strings.get("parser.nonbooleanNotAllowed", new Object[]{Character.toString(arg.charAt(i)), arg}));
                        }
                        this.operands.add(arg);
                        continue block0;
                    }
                    this.setOption(opt, "true");
                }
                continue;
            }
            if (opt == null) {
                if (!this.ignoreUnknown) {
                    this.invalidOptions.add(arg);
                }
                this.operands.add(arg);
                continue;
            }
            if (value == null) {
                String val;
                if (this.options == null) {
                    if (si + 1 < argv.length && !argv[si + 1].startsWith("-")) {
                        value = argv[++si];
                    } else {
                        ((CommandModelData.ParamModelData)opt).type = Boolean.class;
                    }
                } else if (Parser.optionRequiresOperand(opt)) {
                    if (++si >= argv.length) {
                        throw new CommandValidationException(strings.get("parser.missingValue", new Object[]{name}));
                    }
                    value = argv[si];
                } else if ((opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) && si + 1 < argv.length && ((val = argv[si + 1]).equalsIgnoreCase("true") || val.equalsIgnoreCase("false"))) {
                    ++si;
                    value = val;
                }
            }
            if (!this.invalidOptions.isEmpty()) continue;
            this.setOption(opt, value);
        }
        if (this.invalidOptions.size() == 1) {
            throw new CommandValidationException(strings.get("parser.invalidOption", new Object[]{this.invalidOptions.iterator().next()}));
        }
        if (this.invalidOptions.size() > 1) {
            throw new CommandValidationException(strings.get("parser.invalidOptions", new Object[]{StringUtils.cat((String)" ", (String[])this.invalidOptions.toArray(new String[0]))}));
        }
    }

    public ParameterMap getOptions() {
        return this.optionsMap;
    }

    public List<String> getOperands() {
        return this.operands;
    }

    public String toString() {
        return "CLI parser: Options = " + this.optionsMap + "; Operands = " + this.operands;
    }

    private CommandModel.ParamModel lookupLongOption(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (this.options == null) {
            return new CommandModelData.ParamModelData(s, String.class, true, null);
        }
        for (CommandModel.ParamModel od : this.options) {
            if (od.getParam().primary()) continue;
            if (s.equalsIgnoreCase(od.getName())) {
                return od;
            }
            if (!s.equalsIgnoreCase(od.getParam().alias())) continue;
            return od;
        }
        return null;
    }

    private CommandModel.ParamModel lookupShortOption(char c) {
        if (this.options == null) {
            return null;
        }
        String sc = Character.toString(c);
        for (CommandModel.ParamModel od : this.options) {
            if (!od.getParam().shortName().equals(sc)) continue;
            return od;
        }
        return null;
    }

    private static boolean optionRequiresOperand(CommandModel.ParamModel opt) {
        return opt != null && opt.getType() != Boolean.class && opt.getType() != Boolean.TYPE;
    }

    private void setOption(CommandModel.ParamModel opt, String value) throws CommandValidationException {
        if (opt == null) {
            throw new NullPointerException("null option name");
        }
        if (value != null) {
            value = StringUtils.trimQuotes((String)value.trim());
        }
        String name = opt.getName();
        if (opt.getType() == File.class) {
            File f = new File(value);
            if (!(value.equals("-") || f.isFile() || f.canRead())) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(f);
                }
                catch (IOException ioex) {
                    throw new CommandValidationException(strings.get("parser.invalidFileEx", new Object[]{name, ioex.toString()}));
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                throw new CommandValidationException(strings.get("parser.invalidFile", new Object[]{name, value}));
            }
        } else if (opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) {
            if (value == null) {
                value = "true";
            } else if (!value.toLowerCase(Locale.ENGLISH).equals("true") && !value.toLowerCase(Locale.ENGLISH).equals("false")) {
                throw new CommandValidationException(strings.get("parser.invalidBoolean", new Object[]{name, value}));
            }
        } else if (opt.getParam().password()) {
            throw new CommandValidationException(strings.get("parser.passwordNotAllowed", new Object[]{opt.getName()}));
        }
        if (!opt.getParam().multiple() && this.optionsMap.containsKey((Object)name)) {
            throw new CommandValidationException(strings.get("parser.noRepeats", new Object[]{name}));
        }
        this.optionsMap.add((Object)name, (Object)value);
    }
}

