/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107;

import fish.payara.cdi.jsr107.AbstractJSR107Interceptor;
import fish.payara.cdi.jsr107.implementation.PayaraCacheKeyInvocationContext;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.GeneratedCacheKey;

@CachePut
@Interceptor
@Priority(value=4000)
public class CachePutInterceptor
extends AbstractJSR107Interceptor {
    @AroundInvoke
    public Object cachePut(InvocationContext ctx) throws Throwable {
        if (!this.isEnabled()) {
            return ctx.proceed();
        }
        CachePut annotation = ctx.getMethod().getAnnotation(CachePut.class);
        PayaraCacheKeyInvocationContext<CachePut> pctx = new PayaraCacheKeyInvocationContext<CachePut>(ctx, annotation);
        if (!annotation.afterInvocation()) {
            this.doPut(pctx);
        }
        Object result = null;
        try {
            result = ctx.proceed();
        }
        catch (Throwable e) {
            if (annotation.afterInvocation() && this.shouldICache(annotation.cacheFor(), annotation.noCacheFor(), e, false)) {
                this.doPut(pctx);
            }
            throw e;
        }
        if (annotation.afterInvocation()) {
            this.doPut(pctx);
        }
        return result;
    }

    private void doPut(PayaraCacheKeyInvocationContext<CachePut> pctx) throws Throwable {
        CacheKeyGenerator generator = pctx.getGenerator();
        CacheResolverFactory resolverF = pctx.getFactory();
        CacheResolver cacheResolver = resolverF.getCacheResolver(pctx);
        Cache cache = cacheResolver.resolveCache(pctx);
        GeneratedCacheKey key = generator.generateCacheKey(pctx);
        Object value = pctx.getValueParameter().getValue();
        cache.put((Object)key, value);
    }
}

