/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.jaspic;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.soteria.cdi.CdiUtils;
import org.glassfish.soteria.cdi.spi.CDIPerRequestInitializer;
import org.glassfish.soteria.mechanisms.BasicAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.CustomFormAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.FormAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.HttpMessageContextImpl;
import org.glassfish.soteria.mechanisms.jaspic.Jaspic;

public class HttpBridgeServerAuthModule
implements ServerAuthModule {
    private static final Map<String, String> mappings = new HashMap<String, String>();
    public static final String SECURITY_MECHANISM_PARAMETER = "fish.payara.security.mechanism";
    private final Class<?>[] supportedMessageTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private final CDIPerRequestInitializer cdiPerRequestInitializer;
    private final Map<String, Class<? extends HttpAuthenticationMechanism>> mechanismClassCache = new ConcurrentHashMap<String, Class<? extends HttpAuthenticationMechanism>>(3);
    private CallbackHandler handler;

    public HttpBridgeServerAuthModule(CDIPerRequestInitializer cdiPerRequestInitializer) {
        this.cdiPerRequestInitializer = cdiPerRequestInitializer;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
    }

    public Class<?>[] getSupportedMessageTypes() {
        return this.supportedMessageTypes;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, clientSubject);
        if (this.cdiPerRequestInitializer != null) {
            this.cdiPerRequestInitializer.init(msgContext.getRequest());
        }
        AuthenticationStatus status = AuthenticationStatus.NOT_DONE;
        Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), status);
        try {
            HttpAuthenticationMechanism mechanismInstance = this.getMechanism(msgContext);
            status = mechanismInstance.validateRequest(msgContext.getRequest(), msgContext.getResponse(), (HttpMessageContext)msgContext);
        }
        catch (AuthenticationException e) {
            Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), AuthenticationStatus.SEND_FAILURE);
            throw (AuthException)new AuthException("Authentication failure in HttpAuthenticationMechanism").initCause((Throwable)e);
        }
        Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), status);
        return Jaspic.fromAuthenticationStatus(status);
    }

    private HttpAuthenticationMechanism getMechanism(HttpMessageContext ctx) throws AuthException {
        String mechanism = this.getMechanismName(ctx.getRequest());
        Class<? extends HttpAuthenticationMechanism> mechanismClass = this.findMechanismClass(mechanism);
        return CdiUtils.getBeanReference(mechanismClass, new Annotation[0]);
    }

    private String getMechanismName(HttpServletRequest request) {
        return request.getServletContext().getInitParameter(SECURITY_MECHANISM_PARAMETER);
    }

    private Class<? extends HttpAuthenticationMechanism> findMechanismClass(String mechanism) throws AuthException {
        if (mechanism == null) {
            return HttpAuthenticationMechanism.class;
        }
        String mappedName = mappings.getOrDefault(mechanism, mechanism);
        try {
            return this.mechanismClassCache.computeIfAbsent(mappedName, this::loadMechanismClass);
        }
        catch (RuntimeException e) {
            throw new AuthException(e.getMessage());
        }
    }

    private Class<? extends HttpAuthenticationMechanism> loadMechanismClass(String mechanism) {
        try {
            Class<?> mechanismClass = Thread.currentThread().getContextClassLoader().loadClass(mechanism);
            if (HttpAuthenticationMechanism.class.isAssignableFrom(mechanismClass)) {
                return mechanismClass;
            }
            throw new IllegalArgumentException("Provided authentication class does not implement HttpAuthentication Mechanism: " + mechanism);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("HTTP Authentication mechanism class not found " + e.getMessage());
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, null);
        try {
            HttpAuthenticationMechanism mechanismInstance = this.getMechanism(msgContext);
            AuthenticationStatus status = mechanismInstance.secureResponse(msgContext.getRequest(), msgContext.getResponse(), (HttpMessageContext)msgContext);
            AuthStatus authStatus = Jaspic.fromAuthenticationStatus(status);
            if (authStatus == AuthStatus.SUCCESS) {
                AuthStatus authStatus2 = AuthStatus.SEND_SUCCESS;
                return authStatus2;
            }
            AuthStatus authStatus3 = authStatus;
            return authStatus3;
        }
        catch (AuthenticationException e) {
            throw (AuthException)new AuthException("Secure response failure in HttpAuthenticationMechanism").initCause((Throwable)e);
        }
        finally {
            if (this.cdiPerRequestInitializer != null) {
                this.cdiPerRequestInitializer.destroy(msgContext.getRequest());
            }
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, subject);
        this.getMechanism(msgContext).cleanSubject(msgContext.getRequest(), msgContext.getResponse(), (HttpMessageContext)msgContext);
    }

    static {
        mappings.put("Basic", BasicAuthenticationMechanism.class.getName());
        mappings.put("Form", FormAuthenticationMechanism.class.getName());
        mappings.put("CustomForm", CustomFormAuthenticationMechanism.class.getName());
        mappings.put("JWT", "fish.payara.microprofile.jwtauth.eesecurity.JWTAuthenticationMechanism");
        mappings.put("Certificate", "fish.payara.security.realm.mechanisms.CertificateAuthenticationMechanism");
        mappings.put("OAuth2", "fish.payara.security.oauth2.OAuth2AuthenticationMechanism");
        mappings.put("OIDC", "fish.payara.security.openid.OpenIdAuthenticationMechanism");
        mappings.put("JakartaOIDC", "org.glassfish.soteria.mechanisms.OpenIdAuthenticationMechanism");
        mappings.put("TwoIdentityStore", "fish.payara.security.authentication.twoIdentityStore.TwoIdentityStoreAuthenticationMechanism");
    }
}

