/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import jakarta.inject.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.glassfish.grizzly.config.GrizzlyConfig;
import org.glassfish.grizzly.config.SecurePasswordProvider;
import org.glassfish.grizzly.config.Utils;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.ssl.SSLImplementation;
import org.glassfish.grizzly.config.ssl.ServerSocketFactory;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

public class SSLConfigurator
extends SSLEngineConfigurator {
    private static final String PLAIN_PASSWORD_PROVIDER_NAME = "plain";
    private static final Logger LOGGER = GrizzlyConfig.logger();
    private final Ssl ssl;
    protected final Provider<SSLImplementation> sslImplementation;
    private String sniCertAlias;
    public static final String KEYSTORE_ATTR = "keystore";
    public static final String KEYSTORE_PROP = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_TYPE_ATTR = "keystoreType";
    public static final String KEYSTORE_TYPE_PROP = "javax.net.ssl.keyStoreType";
    public static final String KEYSTORE_PASS_ATTR = "keystorePass";
    public static final String KEYSTORE_PASS_PROP = "javax.net.ssl.keyStorePassword";
    public static final String ADDITIONAL_KEY_STORES_ATTR = "additionalKeystores";
    public static final String ADDITIONAL_KEY_STORES_PROP = "fish.payara.ssl.additionalKeyStores";
    public static final String TRUSTSTORE_ATTR = "truststore";
    public static final String TRUSTSTORE_PROP = "javax.net.ssl.trustStore";
    public static final String ADDITIONAL_TRUST_STORES_ATTR = "additionalTrustStores";
    public static final String ADDITIONAL_TRUST_STORES_PROP = "fish.payara.ssl.additionalTrustStores";
    public static final String TRUSTSTORE_TYPE_ATTR = "truststoreType";
    public static final String TRUSTSTORE_TYPE_PROP = "javax.net.ssl.trustStoreType";
    public static final String TRUSTSTORE_PASS_ATTR = "truststorePass";
    public static final String TRUSTSTORE_PASS_PROP = "javax.net.ssl.trustStorePassword";
    public static final String TLS_SESSION_TIMEOUT_ATTR = "tlsSessionTimeout";
    public static final String TLS_SESSION_TIMEOUT_PROP = "javax.net.ssl.sessionTimeout";
    public static final String TLS_SESSION_CACHE_SIZE_ATTR = "tlsSessionCacheSize";
    public static final String TLS_SESSION_CACHE_SIZE_PROP = "javax.net.ssl.sessionCacheSize";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";

    public SSLConfigurator(ServiceLocator habitat, Ssl ssl) {
        Object sslImplementationLocal;
        this.ssl = ssl;
        final ServiceHandle handle = habitat.getServiceHandle(SSLImplementation.class, ssl.getClassname(), new Annotation[0]);
        if (handle != null) {
            sslImplementationLocal = new Provider<SSLImplementation>(){

                public SSLImplementation get() {
                    return (SSLImplementation)handle.getService();
                }
            };
        } else {
            final SSLImplementation impl = SSLConfigurator.lookupSSLImplementation(habitat, ssl);
            if (impl == null) {
                throw new IllegalStateException("Can not configure SSLImplementation");
            }
            sslImplementationLocal = new Provider<SSLImplementation>(){

                public SSLImplementation get() {
                    return impl;
                }
            };
        }
        this.sslImplementation = sslImplementationLocal;
        this.setNeedClientAuth(SSLConfigurator.isNeedClientAuth(ssl));
        this.setWantClientAuth(SSLConfigurator.isWantClientAuth(ssl));
        this.clientMode = false;
        this.sslContextConfiguration = new InternalSSLContextConfigurator();
    }

    public SSLImplementation getSslImplementation() {
        return (SSLImplementation)this.sslImplementation.get();
    }

    public void setSNICertAlias(String alias) {
        this.sniCertAlias = alias;
    }

    protected SSLContext configureSSL() {
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        try {
            SSLContext newSslContext = this.initializeSSLContext();
            if (this.ssl != null) {
                String[] ciphers;
                if (Boolean.parseBoolean(this.ssl.getTls12Enabled())) {
                    tmpSSLArtifactsList.add("TLSv1.2");
                }
                if (Boolean.parseBoolean(this.ssl.getTls13Enabled())) {
                    tmpSSLArtifactsList.add("TLSv1.3");
                }
                if (tmpSSLArtifactsList.isEmpty()) {
                    this.logEmptyWarning(this.ssl, "WEB0307: All SSL protocol variants disabled for network-listener {0}, using SSL implementation specific defaults");
                } else {
                    String[] protocols = new String[tmpSSLArtifactsList.size()];
                    tmpSSLArtifactsList.toArray(protocols);
                    this.setEnabledProtocols(protocols);
                }
                tmpSSLArtifactsList.clear();
                String ssl3Ciphers = this.ssl.getSsl3TlsCiphers();
                if (ssl3Ciphers != null && ssl3Ciphers.length() > 0) {
                    String[] ssl3CiphersArray;
                    for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                        tmpSSLArtifactsList.add(cipher.trim());
                    }
                }
                if ((ciphers = SSLConfigurator.getJSSECiphers(tmpSSLArtifactsList)) == null || ciphers.length == 0) {
                    this.logEmptyWarning(this.ssl, "WEB0308: All SSL cipher suites disabled for network-listener(s) {0}.  Using SSL implementation specific defaults");
                } else {
                    this.setEnabledCipherSuites(ciphers);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Enabled secure protocols={0} ciphers={1}", new Object[]{Arrays.toString(this.getEnabledProtocols()), Arrays.toString(this.getEnabledCipherSuites())});
            }
            return newSslContext;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), e);
            }
            return null;
        }
    }

    protected SSLContext initializeSSLContext() {
        SSLContext newSslContext;
        block8: {
            newSslContext = null;
            try {
                String certAlias;
                ServerSocketFactory serverSF = this.getSslImplementation().getServerSocketFactory();
                if (this.ssl != null) {
                    if (this.ssl.getCrlFile() != null) {
                        SSLConfigurator.setAttribute(serverSF, "crlFile", this.ssl.getCrlFile(), null, null);
                    }
                    if (this.ssl.getTrustAlgorithm() != null) {
                        SSLConfigurator.setAttribute(serverSF, "truststoreAlgorithm", this.ssl.getTrustAlgorithm(), null, null);
                    }
                    if (this.ssl.getKeyAlgorithm() != null) {
                        SSLConfigurator.setAttribute(serverSF, "algorithm", this.ssl.getKeyAlgorithm(), null, null);
                    }
                    SSLConfigurator.setAttribute(serverSF, "trustMaxCertLength", this.ssl.getTrustMaxCertLength(), null, null);
                    SSLConfigurator.setAttribute(serverSF, KEYSTORE_ATTR, this.ssl.getKeyStore(), KEYSTORE_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, ADDITIONAL_KEY_STORES_ATTR, this.ssl.getKeyStore(), ADDITIONAL_KEY_STORES_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, KEYSTORE_TYPE_ATTR, this.ssl.getKeyStoreType(), KEYSTORE_TYPE_PROP, DEFAULT_KEYSTORE_TYPE);
                    SSLConfigurator.setAttribute(serverSF, KEYSTORE_PASS_ATTR, this.getKeyStorePassword(this.ssl), KEYSTORE_PASS_PROP, DEFAULT_KEYSTORE_PASSWORD);
                    SSLConfigurator.setAttribute(serverSF, TRUSTSTORE_ATTR, this.ssl.getTrustStore(), TRUSTSTORE_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, ADDITIONAL_TRUST_STORES_ATTR, this.ssl.getTrustStore(), ADDITIONAL_TRUST_STORES_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, TRUSTSTORE_TYPE_ATTR, this.ssl.getTrustStoreType(), TRUSTSTORE_TYPE_PROP, DEFAULT_KEYSTORE_TYPE);
                    SSLConfigurator.setAttribute(serverSF, TRUSTSTORE_PASS_ATTR, this.getTrustStorePassword(this.ssl), TRUSTSTORE_PASS_PROP, DEFAULT_KEYSTORE_PASSWORD);
                    SSLConfigurator.setAttribute(serverSF, TLS_SESSION_TIMEOUT_ATTR, this.ssl.getTlsSessionTimeout(), TLS_SESSION_TIMEOUT_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, TLS_SESSION_CACHE_SIZE_ATTR, this.ssl.getTlsSessionCacheSize(), TLS_SESSION_CACHE_SIZE_PROP, null);
                } else {
                    SSLConfigurator.setAttribute(serverSF, KEYSTORE_ATTR, null, KEYSTORE_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, ADDITIONAL_KEY_STORES_ATTR, null, ADDITIONAL_KEY_STORES_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, KEYSTORE_TYPE_ATTR, null, KEYSTORE_TYPE_PROP, DEFAULT_KEYSTORE_TYPE);
                    SSLConfigurator.setAttribute(serverSF, KEYSTORE_PASS_ATTR, null, KEYSTORE_PASS_PROP, DEFAULT_KEYSTORE_PASSWORD);
                    SSLConfigurator.setAttribute(serverSF, TRUSTSTORE_ATTR, null, TRUSTSTORE_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, ADDITIONAL_TRUST_STORES_ATTR, null, ADDITIONAL_TRUST_STORES_PROP, null);
                    SSLConfigurator.setAttribute(serverSF, TRUSTSTORE_TYPE_ATTR, null, TRUSTSTORE_TYPE_PROP, DEFAULT_KEYSTORE_TYPE);
                    SSLConfigurator.setAttribute(serverSF, TRUSTSTORE_PASS_ATTR, null, TRUSTSTORE_PASS_PROP, DEFAULT_KEYSTORE_PASSWORD);
                }
                String string = certAlias = this.ssl != null ? this.ssl.getCertNickname() : null;
                if (this.sniCertAlias != null) {
                    certAlias = this.sniCertAlias;
                }
                serverSF.setAttribute("keyAlias", certAlias);
                serverSF.init();
                newSslContext = serverSF.getSSLContext();
                CipherInfo.updateCiphers(newSslContext);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block8;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), e);
            }
        }
        return newSslContext;
    }

    protected void logEmptyWarning(Ssl ssl, String msg) {
        StringBuilder name = new StringBuilder();
        for (NetworkListener listener : ((Protocol)ssl.getParent()).findNetworkListeners()) {
            if (name.length() != 0) {
                name.append(", ");
            }
            name.append(listener.getName());
        }
        LOGGER.log(Level.FINE, msg, name.toString());
    }

    public boolean isAllowLazyInit() {
        return this.ssl == null || Boolean.parseBoolean(this.ssl.getAllowLazyInit());
    }

    private static void setAttribute(ServerSocketFactory serverSF, String name, String value, String property, String defaultValue) {
        serverSF.setAttribute(name, value == null ? System.getProperty(property, defaultValue) : value);
    }

    private static boolean isWantClientAuth(Ssl ssl) {
        String auth = ssl.getClientAuth();
        return auth != null && "want".equalsIgnoreCase(auth.trim());
    }

    private static boolean isNeedClientAuth(Ssl ssl) {
        if (Boolean.parseBoolean(ssl.getClientAuthEnabled())) {
            return true;
        }
        String auth = ssl.getClientAuth();
        return auth != null && "need".equalsIgnoreCase(auth.trim());
    }

    private static SSLImplementation lookupSSLImplementation(ServiceLocator habitat, Ssl ssl) {
        try {
            String sslImplClassName = ssl.getClassname();
            if (sslImplClassName != null) {
                SSLImplementation impl = Utils.newInstance(habitat, SSLImplementation.class, sslImplClassName, sslImplClassName);
                if (impl != null) {
                    return impl;
                }
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(LogMessages.WARNING_GRIZZLY_CONFIG_SSL_SSL_IMPLEMENTATION_LOAD_ERROR(sslImplClassName));
                }
                return SSLImplementation.getInstance();
            }
            return SSLImplementation.getInstance();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), e);
            }
            return null;
        }
    }

    private static String[] getJSSECiphers(List<String> configuredCiphers) {
        HashSet<String> enabledCiphers = null;
        for (String cipher : configuredCiphers) {
            String jsseCipher;
            if (cipher.length() <= 0 || cipher.charAt(0) == '-') continue;
            if (cipher.charAt(0) == '+') {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = SSLConfigurator.getJSSECipher(cipher)) == null) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning(LogMessages.WARNING_GRIZZLY_CONFIG_SSL_UNKNOWN_CIPHER_ERROR(cipher));
                continue;
            }
            if (enabledCiphers == null) {
                enabledCiphers = new HashSet<String>(configuredCiphers.size());
            }
            enabledCiphers.add(jsseCipher);
        }
        return enabledCiphers == null ? null : enabledCiphers.toArray(new String[enabledCiphers.size()]);
    }

    private static String getJSSECipher(String cipher) {
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        return ci != null ? ci.getCipherName() : null;
    }

    private String getKeyStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getKeyStorePasswordProvider())) {
            return ssl.getKeyStorePassword();
        }
        return this.getStorePasswordCustom(ssl.getKeyStorePassword());
    }

    private String getTrustStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getTrustStorePasswordProvider())) {
            return ssl.getTrustStorePassword();
        }
        return this.getStorePasswordCustom(ssl.getTrustStorePassword());
    }

    private String getStorePasswordCustom(String storePasswordProvider) {
        try {
            SecurePasswordProvider provider = (SecurePasswordProvider)Utils.newInstance(storePasswordProvider);
            assert (provider != null);
            return provider.getPassword();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_SECURE_PASSWORD_INITIALIZATION_ERROR(storePasswordProvider), e);
            }
            return null;
        }
    }

    private static final class CipherInfo {
        private static final short TLS = 4;
        private static final String[][] OLD_CIPHER_MAPPING = new String[][]{{"rsa_null_md5", "SSL_RSA_WITH_NULL_MD5"}, {"rsa_null_sha", "SSL_RSA_WITH_NULL_SHA"}, {"rsa_rc4_40_md5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"rsa_rc4_128_md5", "SSL_RSA_WITH_RC4_128_MD5"}, {"rsa_rc4_128_sha", "SSL_RSA_WITH_RC4_128_SHA"}, {"rsa_3des_sha", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"fips_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_MD5"}, {"SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_SHA"}};
        private static final Map<String, CipherInfo> ciphers = new HashMap<String, CipherInfo>();
        private static final ReadWriteLock ciphersLock = new ReentrantReadWriteLock();
        private final String configName;
        private final String cipherName;
        private final short protocolVersion;

        private CipherInfo(String configName, String cipherName, short protocolVersion) {
            this.configName = configName;
            this.cipherName = cipherName;
            this.protocolVersion = protocolVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateCiphers(SSLContext sslContext) {
            SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
            String[] supportedCiphers = factory.getDefaultCipherSuites();
            ciphersLock.writeLock().lock();
            try {
                for (String s : supportedCiphers) {
                    ciphers.put(s, new CipherInfo(s, s, 4));
                }
            }
            finally {
                ciphersLock.writeLock().unlock();
            }
        }

        public static CipherInfo getCipherInfo(String configName) {
            ciphersLock.readLock().lock();
            try {
                CipherInfo cipherInfo = ciphers.get(configName);
                return cipherInfo;
            }
            finally {
                ciphersLock.readLock().unlock();
            }
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getCipherName() {
            return this.cipherName;
        }

        public boolean isTLS() {
            return (this.protocolVersion & 4) == 4;
        }

        static {
            int len = OLD_CIPHER_MAPPING.length;
            for (int i = 0; i < len; ++i) {
                String nonStdName = OLD_CIPHER_MAPPING[i][0];
                String stdName = OLD_CIPHER_MAPPING[i][1];
                ciphers.put(nonStdName, new CipherInfo(nonStdName, stdName, 4));
            }
        }
    }

    private final class InternalSSLContextConfigurator
    extends SSLContextConfigurator {
        public InternalSSLContextConfigurator() {
            super(false);
        }

        @Override
        public SSLContext createSSLContext() {
            return SSLConfigurator.this.configureSSL();
        }

        @Override
        public SSLContext createSSLContext(boolean throwException) {
            return SSLConfigurator.this.configureSSL();
        }

        @Override
        public boolean validateConfiguration(boolean needsKeyStore) {
            return super.validateConfiguration(needsKeyStore);
        }

        @Override
        public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyPass(String keyPass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyPass(char[] keyPass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStoreFile(String keyStoreFile) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStorePass(String keyStorePass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStorePass(char[] keyStorePass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStoreProvider(String keyStoreProvider) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStoreType(String keyStoreType) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setSecurityProtocol(String securityProtocol) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStoreFile(String trustStoreFile) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStorePass(String trustStorePass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStoreProvider(String trustStoreProvider) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStoreType(String trustStoreType) {
            throw new IllegalStateException("The configuration is immutable");
        }
    }
}

