/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.sni;

import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;

public class SNIConfig {
    private static final SSLEngineConfigurator NULL_SERVER_CONFIG = new NullSSLEngineConfigurator();
    final SSLEngineConfigurator sslEngineConfigurator;
    final String host;
    final boolean isClientConfig;

    public static SNIConfig newServerConfig(SSLEngineConfigurator sslEngineConfigurator) {
        return new SNIConfig(sslEngineConfigurator, null, false);
    }

    public static SNIConfig newClientConfig(String host) {
        return new SNIConfig(null, host, true);
    }

    public static SNIConfig newClientConfig(String host, SSLEngineConfigurator sslEngineConfigurator) {
        return new SNIConfig(sslEngineConfigurator, host, true);
    }

    public static SNIConfig failServerConfig(String host) {
        return new SNIConfig(NULL_SERVER_CONFIG, host, false);
    }

    private SNIConfig(SSLEngineConfigurator engineConfig, String host, boolean isClientConfig) {
        this.sslEngineConfigurator = engineConfig;
        this.host = host;
        this.isClientConfig = isClientConfig;
    }

    private static class NullSSLEngineConfigurator
    extends SSLEngineConfigurator {
        @Override
        public SSLEngine createSSLEngine(String peerHost, int peerPort) {
            throw new IllegalStateException("No SNI config found");
        }

        @Override
        public SSLEngine createSSLEngine() {
            throw new IllegalStateException("No SNI config found");
        }

        @Override
        public SSLEngine configure(SSLEngine sslEngine) {
            throw new IllegalStateException("No SNI config found");
        }

        @Override
        public SSLEngineConfigurator copy() {
            return new NullSSLEngineConfigurator();
        }

        @Override
        public SSLEngineConfigurator setEnabledProtocols(String[] enabledProtocols) {
            throw new IllegalStateException("Immutable config");
        }

        @Override
        public SSLEngineConfigurator setEnabledCipherSuites(String[] enabledCipherSuites) {
            throw new IllegalStateException("Immutable config");
        }

        @Override
        public SSLEngineConfigurator setWantClientAuth(boolean wantClientAuth) {
            throw new IllegalStateException("Immutable config");
        }

        @Override
        public SSLEngineConfigurator setNeedClientAuth(boolean needClientAuth) {
            throw new IllegalStateException("Immutable config");
        }

        @Override
        public SSLEngineConfigurator setClientMode(boolean clientMode) {
            throw new IllegalStateException("Immutable config");
        }
    }
}

