/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.sni;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.sni.SNIClientConfigResolver;
import org.glassfish.grizzly.sni.SNIConfig;
import org.glassfish.grizzly.sni.SNIServerConfigResolver;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.utils.Charsets;

public class SNIFilter
extends SSLFilter {
    private static final Logger LOGGER = Grizzly.logger(SNIFilter.class);
    private static final byte HANDSHAKE_TYPE = 22;
    private static final int MIN_TLS_VERSION = 769;
    private static final int SSLV3_RECORD_HEADER_SIZE = 5;
    private static final int CLIENT_HELLO_HST = 1;
    private SNIServerConfigResolver serverResolver;
    private SNIClientConfigResolver clientResolver;

    public SNIFilter() {
    }

    public SNIFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        super(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
    }

    public SNIFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean renegotiateOnClientAuthWant) {
        super(serverSSLEngineConfigurator, clientSSLEngineConfigurator, renegotiateOnClientAuthWant);
    }

    public SNIServerConfigResolver getServerSSLConfigResolver() {
        return this.serverResolver;
    }

    public void setServerSSLConfigResolver(SNIServerConfigResolver resolver) {
        this.serverResolver = resolver;
    }

    public SNIClientConfigResolver getClientSSLConfigResolver() {
        return this.clientResolver;
    }

    public void setClientSSLConfigResolver(SNIClientConfigResolver resolver) {
        this.clientResolver = resolver;
    }

    @Override
    protected SSLBaseFilter.SSLTransportFilterWrapper createOptimizedTransportFilter(TransportFilter childFilter) {
        return new SNIAwareTransportFilterWrapper(childFilter, this);
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        SSLEngineConfigurator configurator;
        String host;
        Connection c = ctx.getConnection();
        SNIClientConfigResolver resolver = this.clientResolver;
        if (resolver != null) {
            SNIConfig sniConfig = resolver.resolve(c);
            if (sniConfig != null && !sniConfig.isClientConfig) {
                throw new IllegalStateException("SNIConfig has to represent client config, not a server one");
            }
            host = sniConfig != null ? sniConfig.host : null;
            configurator = sniConfig != null && sniConfig.sslEngineConfigurator != null ? sniConfig.sslEngineConfigurator : this.getClientSSLEngineConfigurator();
        } else {
            configurator = this.getClientSSLEngineConfigurator();
            Object addr = c.getPeerAddress();
            host = addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getHostString() : null;
        }
        SSLConnectionContext sslCtx = this.obtainSslConnectionContext(ctx.getConnection());
        SSLEngine sslEngine = host != null ? configurator.createSSLEngine(host, -1) : configurator.createSSLEngine();
        sslCtx.configure(sslEngine);
        sslEngine.beginHandshake();
        this.notifyHandshakeStart(c);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        SNIServerConfigResolver localResolver = this.serverResolver;
        if (localResolver == null) {
            return super.handleRead(ctx);
        }
        Connection c = ctx.getConnection();
        if (SSLUtils.getSslConnectionContext(c) == null) {
            byte byte2;
            byte byte1;
            Buffer input = (Buffer)ctx.getMessage();
            if (input.remaining() < 5) {
                return ctx.getStopAction(input);
            }
            int pos = input.position();
            byte byte0 = input.get(pos++);
            if (SNIFilter.checkTlsVersion(byte0, byte1 = input.get(pos++), byte2 = input.get(pos++))) {
                byte byte3 = input.get(pos++);
                byte byte4 = input.get(pos);
                int len = ((byte3 & 0xFF) << 8) + (byte4 & 0xFF) + 5;
                if (input.remaining() < len) {
                    return ctx.getStopAction(input);
                }
                String hostName = this.getHostName(input, len);
                SNIConfig sniConfig = localResolver.resolve(c, hostName);
                if (sniConfig != null && sniConfig.isClientConfig) {
                    throw new IllegalStateException("SNIConfig has to represent server config, not a client one");
                }
                SSLEngineConfigurator configurator = sniConfig != null && sniConfig.sslEngineConfigurator != null ? sniConfig.sslEngineConfigurator : this.getServerSSLEngineConfigurator();
                SSLConnectionContext sslCtx = this.obtainSslConnectionContext(c);
                SSLEngine sslEngine = configurator.createSSLEngine();
                sslCtx.configure(sslEngine);
                sslEngine.beginHandshake();
                this.notifyHandshakeStart(c);
            }
        }
        return super.handleRead(ctx);
    }

    private String getHostName(Buffer input, int len) {
        int absLen;
        int compressionMethodLength;
        byte handshakeType;
        int current = 5;
        if ((handshakeType = input.get(current++)) != 1) {
            return null;
        }
        current += 3;
        current += 2;
        current += 32;
        int sessionIDLength = input.get(current++) & 0xFF;
        int cipherSuiteLength = input.getShort(current += sessionIDLength) & 0xFFFF;
        current += 2;
        current += cipherSuiteLength;
        if ((current += (compressionMethodLength = input.get(current++) & 0xFF)) >= (absLen = input.position() + len)) {
            return null;
        }
        current += 2;
        while (current < absLen) {
            int extensionType = input.getShort(current) & 0xFFFF;
            int extensionDataLength = input.getShort(current += 2) & 0xFFFF;
            current += 2;
            if (extensionType == 0) {
                int namesCount = input.getShort(current) & 0xFFFF;
                current += 2;
                for (int i = 0; i < namesCount; ++i) {
                    int nameType = input.get(current++) & 0xFF;
                    int nameLen = input.getShort(current) & 0xFFFF;
                    current += 2;
                    if (nameType == 0) {
                        return input.toStringContent(Charsets.ASCII_CHARSET, current, current + nameLen);
                    }
                    current += nameLen;
                }
            }
            current += extensionDataLength;
        }
        return null;
    }

    static boolean checkTlsVersion(byte byte0, byte major, byte minor) {
        return byte0 == 22 && (major << 8 | minor & 0xFF) >= 769;
    }

    private static final class SNIAwareTransportFilterWrapper
    extends SSLBaseFilter.SSLTransportFilterWrapper {
        public SNIAwareTransportFilterWrapper(TransportFilter transportFilter, SSLBaseFilter sslBaseFilter) {
            super(transportFilter, sslBaseFilter);
        }

        @Override
        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            Connection connection = ctx.getConnection();
            SSLConnectionContext sslCtx = SSLUtils.getSslConnectionContext(connection);
            if (sslCtx != null && sslCtx.getSslEngine() != null) {
                ctx.setMessage(SSLUtils.allowDispose(SSLUtils.allocateInputBuffer(sslCtx)));
            }
            return this.wrappedFilter.handleRead(ctx);
        }
    }
}

