/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.executorservice.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.executorservice.PayaraExecutorServiceConfiguration;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Min;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-payara-executor-service-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=PayaraExecutorServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-payara-executor-service-configuration", description="Sets the Payara Executor Service Configuration")})
public class SetPayaraExecutorServiceConfigurationCommand
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Inject
    ServerEnvironment serverEnvironment;
    @Inject
    PayaraExecutorService payaraExecutorService;
    @Param(name="threadPoolExecutorCorePoolSize", optional=true, alias="threadpoolexecutorcorepoolsize")
    private Integer threadPoolExecutorCorePoolSize;
    @Param(name="threadPoolExecutorMaxPoolSize", optional=true, alias="threadpoolexecutormaxpoolsize")
    private Integer threadPoolExecutorMaxPoolSize;
    @Param(name="threadPoolExecutorKeepAliveTime", optional=true, alias="threadpoolexecutorkeepalivetime")
    @Min(value=1L, message="Keep alive time must be greater than 1")
    private @Min(value=1L, message="Keep alive time must be greater than 1") String threadPoolExecutorKeepAliveTime;
    @Param(name="threadPoolExecutorKeepAliveTimeUnit", optional=true, alias="threadpoolexecutorkeepalivetimeunit", acceptableValues="days,DAYS,hours,HOURS,microseconds,MICROSECONDS,milliseconds,MILLISECONDS,minutes,MINUTES,nanoseconds,NANOSECONDS,seconds,SECONDS")
    private String threadPoolExecutorKeepAliveTimeUnit;
    @Param(name="threadPoolExecutorQueueSize", optional=true, alias="threadpoolexecutorqueuesize")
    private Integer threadPoolExecutorQueueSize;
    @Param(name="scheduledThreadPoolExecutorCorePoolSize", optional=true, alias="scheduledthreadpoolexecutorcorepoolsize")
    private Integer scheduledThreadPoolExecutorCorePoolSize;
    @Param(name="target", optional=true, defaultValue="server-config")
    private String target;

    public void execute(AdminCommandContext acc) {
        Config configVal = this.targetUtil.getConfig(this.target);
        PayaraExecutorServiceConfiguration payaraExecutorServiceConfiguration = (PayaraExecutorServiceConfiguration)configVal.getExtensionByType(PayaraExecutorServiceConfiguration.class);
        if (payaraExecutorServiceConfiguration != null) {
            try {
                ConfigSupport.apply(config -> {
                    if (this.threadPoolExecutorCorePoolSize != null) {
                        config.setThreadPoolExecutorCorePoolSize(this.threadPoolExecutorCorePoolSize);
                    }
                    if (this.threadPoolExecutorMaxPoolSize != null) {
                        config.setThreadPoolExecutorMaxPoolSize(this.threadPoolExecutorMaxPoolSize);
                    }
                    if (this.threadPoolExecutorKeepAliveTime != null) {
                        config.setThreadPoolExecutorKeepAliveTime(this.threadPoolExecutorKeepAliveTime);
                    }
                    if (this.threadPoolExecutorKeepAliveTimeUnit != null) {
                        config.setThreadPoolExecutorKeepAliveTimeUnit(this.threadPoolExecutorKeepAliveTimeUnit.toUpperCase());
                    }
                    if (this.threadPoolExecutorQueueSize != null) {
                        config.setThreadPoolExecutorQueueSize(this.threadPoolExecutorQueueSize);
                    }
                    if (this.scheduledThreadPoolExecutorCorePoolSize != null) {
                        config.setScheduledThreadPoolExecutorCorePoolSize(this.scheduledThreadPoolExecutorCorePoolSize);
                    }
                    return null;
                }, (ConfigBeanProxy)payaraExecutorServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                acc.getActionReport().failure(Logger.getLogger(SetPayaraExecutorServiceConfigurationCommand.class.getName()), "Failed to set executor service configuration", (Throwable)ex);
            }
        }
    }
}

