/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.factory;

import com.sun.jaspic.config.factory.RegistrationContextImpl;
import jakarta.security.auth.message.config.AuthConfigFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class EntryInfo {
    private final String className;
    private final Map<String, String> properties;
    private List<AuthConfigFactory.RegistrationContext> registrationContexts;

    public EntryInfo(String className) {
        this(className, null);
    }

    public EntryInfo(String className, Map<String, String> properties) {
        if (className == null) {
            throw new IllegalArgumentException("Class name for registration entry cannot be null");
        }
        this.className = className;
        this.properties = properties;
    }

    EntryInfo(String className, Map<String, String> properties, List<AuthConfigFactory.RegistrationContext> ctxs) {
        if (ctxs == null || ctxs.isEmpty()) {
            throw new IllegalArgumentException("Registration entry must contain one or more registration contexts");
        }
        this.className = className;
        this.properties = properties;
        this.registrationContexts = ctxs;
    }

    EntryInfo(String className, Map<String, String> properties, AuthConfigFactory.RegistrationContext registrationContext) {
        this.className = className;
        this.properties = properties;
        if (registrationContext != null) {
            RegistrationContextImpl ctxImpl = new RegistrationContextImpl(registrationContext.getMessageLayer(), registrationContext.getAppContext(), registrationContext.getDescription(), registrationContext.isPersistent());
            ArrayList<AuthConfigFactory.RegistrationContext> newList = new ArrayList<AuthConfigFactory.RegistrationContext>(1);
            newList.add(ctxImpl);
            this.registrationContexts = newList;
        }
    }

    EntryInfo(EntryInfo parent) {
        this.className = parent.className;
        this.properties = parent.properties;
        if (parent.registrationContexts != null) {
            this.registrationContexts = new ArrayList<AuthConfigFactory.RegistrationContext>(1);
            for (AuthConfigFactory.RegistrationContext registrationContext : parent.registrationContexts) {
                this.registrationContexts.add(registrationContext);
            }
        }
    }

    boolean isConstructorEntry() {
        return this.registrationContexts == null;
    }

    String getClassName() {
        return this.className;
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    List<AuthConfigFactory.RegistrationContext> getRegistrationContexts() {
        return this.registrationContexts;
    }

    boolean matchConstructors(EntryInfo target) {
        if (target == null) {
            return false;
        }
        return !(this.isConstructorEntry() ^ target.isConstructorEntry()) && EntryInfo.matchStrings(this.className, target.getClassName()) && EntryInfo.matchMaps(this.properties, target.getProperties());
    }

    static boolean matchStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean matchMaps(Map<String, String> map1, Map<String, String> map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        return map1.equals(map2);
    }
}

