/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.servlet;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.BaseAuthContextImpl;
import com.sun.jaspic.config.jaas.JAASAuthConfigProvider;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;

public class JAASServletAuthConfigProvider
extends JAASAuthConfigProvider {
    private static final String HTTP_SERVLET_LAYER = "HttpServlet";
    private static final String MANDATORY_KEY = "jakarta.security.auth.message.MessagePolicy.isMandatory";
    private static final String MANDATORY_AUTH_CONTEXT_ID = "mandatory";
    private static final String OPTIONAL_AUTH_CONTEXT_ID = "optional";
    private static final Class<?>[] moduleTypes = new Class[]{ServerAuthModule.class};
    private static final Class<?>[] messageTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private static final MessagePolicy mandatoryPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender")}, true);
    private static final MessagePolicy optionalPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender")}, false);

    public JAASServletAuthConfigProvider(Map<String, String> properties, AuthConfigFactory factory) {
        super(properties, factory);
    }

    @Override
    public MessagePolicyDelegate getMessagePolicyDelegate(String appContext) throws AuthException {
        return new MessagePolicyDelegate(){

            public MessagePolicy getRequestPolicy(String authContextID, Map properties) {
                return JAASServletAuthConfigProvider.MANDATORY_AUTH_CONTEXT_ID.equals(authContextID) ? mandatoryPolicy : optionalPolicy;
            }

            public MessagePolicy getResponsePolicy(String authContextID, Map properties) {
                return null;
            }

            @Override
            public Class<?>[] getMessageTypes() {
                return messageTypes;
            }

            @Override
            public String getAuthContextID(MessageInfo messageInfo) {
                return messageInfo.getMap().containsKey(JAASServletAuthConfigProvider.MANDATORY_KEY) ? JAASServletAuthConfigProvider.MANDATORY_AUTH_CONTEXT_ID : JAASServletAuthConfigProvider.OPTIONAL_AUTH_CONTEXT_ID;
            }

            @Override
            public boolean isProtected() {
                return true;
            }
        };
    }

    @Override
    protected Class<?>[] getModuleTypes() {
        return moduleTypes;
    }

    @Override
    protected String getLayer() {
        return HTTP_SERVLET_LAYER;
    }

    @Override
    public BaseAuthContextImpl getAuthContextHelper(String appContext, boolean returnNullContexts) throws AuthException {
        return super.getAuthContextHelper(appContext, false);
    }
}

