/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.realm.Realm;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.types.Property;

public class RealmConfig {
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();

    public static void createRealms(String defaultRealm, List<AuthRealm> realms) {
        RealmConfig.createRealms(defaultRealm, realms, null);
    }

    public static void createRealms(String defaultRealm, List<AuthRealm> realms, String configName) {
        String goodRealm = null;
        for (AuthRealm realm : realms) {
            String realmName = realm.getName();
            String realmClass = realm.getClassname();
            try {
                List realmProperties = realm.getProperty();
                Properties properties = new Properties();
                for (Property realmProperty : realmProperties) {
                    properties.setProperty(realmProperty.getName(), realmProperty.getValue());
                }
                Realm.instantiate(realmName, realmClass, properties, configName);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Configured realm: {0}", realmName);
                }
                if (goodRealm != null) continue;
                goodRealm = realmName;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "NCLS-SECURITY-01100", realmName);
                LOGGER.log(Level.WARNING, "NCLS-SECURITY-01000", e);
            }
        }
        if (goodRealm == null) {
            LOGGER.severe("NCLS-SECURITY-01101");
        } else {
            try {
                Realm.getInstance(defaultRealm);
            }
            catch (Exception e) {
                defaultRealm = goodRealm;
            }
            Realm.setDefaultRealm(defaultRealm);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Default realm is set to: {0}", defaultRealm);
            }
        }
    }
}

