/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.JavaEEScanner;

public class DirectoryScanner
extends JavaEEScanner
implements Scanner<Object> {
    private File directory;
    private Set<String> entries = new HashSet<String>();
    private ClassLoader classLoader = null;

    @Override
    public void process(File directory, Object bundleDesc, ClassLoader classLoader) throws IOException {
        AnnotationUtils.getLogger().log(Level.FINER, "dir is {0}", directory);
        AnnotationUtils.getLogger().log(Level.FINER, "classLoader is {0}", classLoader);
        this.directory = directory;
        this.classLoader = classLoader;
        this.init(directory);
    }

    private void init(File directory) throws IOException {
        this.init(directory, directory);
        this.initTypes(directory);
    }

    private void init(File top, File directory) throws IOException {
        File[] subDirs;
        File[] dirFiles;
        for (File file : dirFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".class");
            }
        })) {
            this.entries.add(file.getPath().substring(top.getPath().length() + 1));
        }
        for (File subDir : subDirs = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            this.init(top, subDir);
        }
    }

    protected Set<String> getEntries() {
        return this.entries;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            final URL[] urls = new URL[1];
            try {
                if (this.directory == null) {
                    throw new IllegalStateException("directory must first be set by calling the process method.");
                }
                urls[0] = this.directory.getAbsoluteFile().toURL();
                this.classLoader = new PrivilegedAction<URLClassLoader>(){

                    @Override
                    public URLClassLoader run() {
                        return new URLClassLoader(urls);
                    }
                }.run();
            }
            catch (Exception e) {
                AnnotationUtils.getLogger().log(Level.SEVERE, null, e);
            }
        }
        return this.classLoader;
    }

    @Override
    public Set<Class> getElements() {
        return this.getElements(this.entries);
    }

    @Override
    public Set<Class> getElements(Set<String> classNames) {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (String fileName : classNames) {
            String className = fileName.replace(File.separatorChar, '.');
            className = className.substring(0, className.length() - 6);
            AnnotationUtils.getLogger().log(Level.FINE, "Getting {0}", className);
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (Throwable cnfe) {
                AnnotationUtils.getLogger().log(Level.SEVERE, "cannot load {0} reason : {1}", new Object[]{className, cnfe.getMessage()});
            }
        }
        return elements;
    }
}

