/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import java.nio.file.Path;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoUndeploymentOperation;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Deprecated
@Service(name="disable-ejb-invoker")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
public class DisableEjbInvokerCommand
implements AdminCommand {
    @Param(optional=true)
    public String target;
    @Inject
    private ServerEnvironment serverEnvironment;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        Path endPointsPath = this.serverEnvironment.getInstanceRoot().toPath().resolve("endpoints");
        Path ejbInvokerPath = endPointsPath.resolve("__ejb-invoker");
        AutoUndeploymentOperation autoUndeploymentOperation = AutoUndeploymentOperation.newInstance(this.serviceLocator, ejbInvokerPath.toFile(), AutoDeployer.getNameFromFilePath(endPointsPath.toFile(), ejbInvokerPath.toFile()), this.target);
        AutoDeployer.AutodeploymentStatus undeploymentStatus = autoUndeploymentOperation.run();
        ActionReport report = context.getActionReport();
        report.setActionExitCode(undeploymentStatus.getExitCode());
        if (undeploymentStatus.getExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
            if (this.domain.getApplications().getApplication("__ejb-invoker") == null) {
                report.appendMessage("\nEJB Invoker is not enabled on any target");
            } else {
                report.appendMessage("\nFailed to disable Ejb Invoker - was it enabled on the specified target?");
            }
        }
        context.getActionReport().setMessage("\ndisable-ejb-invoker command is deprecated.\nPlease use the 'set-ejb-invoker-configuration --enabled=false' asadmin command to disable the service.");
    }
}

